/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DiscoveredDeviceSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListDiscoveredDevicesResponse;

public class ListDiscoveredDevicesPublisher
implements SdkPublisher<ListDiscoveredDevicesResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListDiscoveredDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDiscoveredDevicesPublisher(IotManagedIntegrationsAsyncClient client, ListDiscoveredDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDiscoveredDevicesPublisher(IotManagedIntegrationsAsyncClient client, ListDiscoveredDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDiscoveredDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDiscoveredDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DiscoveredDeviceSummary> items() {
        Function<ListDiscoveredDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDiscoveredDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDiscoveredDevicesResponseFetcher
    implements AsyncPageFetcher<ListDiscoveredDevicesResponse> {
        private ListDiscoveredDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListDiscoveredDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDiscoveredDevicesResponse> nextPage(ListDiscoveredDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListDiscoveredDevicesPublisher.this.client.listDiscoveredDevices(ListDiscoveredDevicesPublisher.this.firstRequest);
            }
            return ListDiscoveredDevicesPublisher.this.client.listDiscoveredDevices((ListDiscoveredDevicesRequest)((Object)ListDiscoveredDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

