/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskExecutionsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskExecutionSummaries;

public class ListOtaTaskExecutionsPublisher
implements SdkPublisher<ListOtaTaskExecutionsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListOtaTaskExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOtaTaskExecutionsPublisher(IotManagedIntegrationsAsyncClient client, ListOtaTaskExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOtaTaskExecutionsPublisher(IotManagedIntegrationsAsyncClient client, ListOtaTaskExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOtaTaskExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOtaTaskExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OtaTaskExecutionSummaries> executionSummaries() {
        Function<ListOtaTaskExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.executionSummaries() != null) {
                return response.executionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOtaTaskExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOtaTaskExecutionsResponseFetcher
    implements AsyncPageFetcher<ListOtaTaskExecutionsResponse> {
        private ListOtaTaskExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOtaTaskExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOtaTaskExecutionsResponse> nextPage(ListOtaTaskExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListOtaTaskExecutionsPublisher.this.client.listOtaTaskExecutions(ListOtaTaskExecutionsPublisher.this.firstRequest);
            }
            return ListOtaTaskExecutionsPublisher.this.client.listOtaTaskExecutions((ListOtaTaskExecutionsRequest)((Object)ListOtaTaskExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

