/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityDescriptionsCopier;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchEntitiesResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, SearchEntitiesResponse> {
    private static final SdkField<List<EntityDescription>> DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("descriptions").getter(SearchEntitiesResponse.getter(SearchEntitiesResponse::descriptions)).setter(SearchEntitiesResponse.setter(Builder::descriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchEntitiesResponse.getter(SearchEntitiesResponse::nextToken)).setter(SearchEntitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchEntitiesResponse.memberNameToFieldInitializer();
    private final List<EntityDescription> descriptions;
    private final String nextToken;

    private SearchEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.descriptions = builder.descriptions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDescriptions() {
        return this.descriptions != null && !(this.descriptions instanceof SdkAutoConstructList);
    }

    public final List<EntityDescription> descriptions() {
        return this.descriptions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDescriptions() ? this.descriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEntitiesResponse)) {
            return false;
        }
        SearchEntitiesResponse other = (SearchEntitiesResponse)((Object)obj);
        return this.hasDescriptions() == other.hasDescriptions() && Objects.equals(this.descriptions(), other.descriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchEntitiesResponse").add("Descriptions", this.hasDescriptions() ? this.descriptions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "descriptions": {
                return Optional.ofNullable(clazz.cast(this.descriptions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("descriptions", DESCRIPTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchEntitiesResponse, T> g) {
        return obj -> g.apply((SearchEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private List<EntityDescription> descriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEntitiesResponse model) {
            super(model);
            this.descriptions(model.descriptions);
            this.nextToken(model.nextToken);
        }

        public final List<EntityDescription.Builder> getDescriptions() {
            List<EntityDescription.Builder> result = EntityDescriptionsCopier.copyToBuilder(this.descriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDescriptions(Collection<EntityDescription.BuilderImpl> descriptions) {
            this.descriptions = EntityDescriptionsCopier.copyFromBuilder(descriptions);
        }

        @Override
        public final Builder descriptions(Collection<EntityDescription> descriptions) {
            this.descriptions = EntityDescriptionsCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(EntityDescription ... descriptions) {
            this.descriptions(Arrays.asList(descriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(Consumer<EntityDescription.Builder> ... descriptions) {
            this.descriptions(Stream.of(descriptions).map(c -> (EntityDescription)((EntityDescription.Builder)EntityDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchEntitiesResponse build() {
            return new SearchEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchEntitiesResponse> {
        public Builder descriptions(Collection<EntityDescription> var1);

        public Builder descriptions(EntityDescription ... var1);

        public Builder descriptions(Consumer<EntityDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

