/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.AutoScalingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingSettings> {
    private static final SdkField<Boolean> AUTO_SCALING_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoScalingDisabled").getter(AutoScalingSettings.getter(AutoScalingSettings::autoScalingDisabled)).setter(AutoScalingSettings.setter(Builder::autoScalingDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingDisabled").build()}).build();
    private static final SdkField<Long> MINIMUM_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("minimumUnits").getter(AutoScalingSettings.getter(AutoScalingSettings::minimumUnits)).setter(AutoScalingSettings.setter(Builder::minimumUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumUnits").build()}).build();
    private static final SdkField<Long> MAXIMUM_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("maximumUnits").getter(AutoScalingSettings.getter(AutoScalingSettings::maximumUnits)).setter(AutoScalingSettings.setter(Builder::maximumUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumUnits").build()}).build();
    private static final SdkField<AutoScalingPolicy> SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingPolicy").getter(AutoScalingSettings.getter(AutoScalingSettings::scalingPolicy)).setter(AutoScalingSettings.setter(Builder::scalingPolicy)).constructor(AutoScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_DISABLED_FIELD, MINIMUM_UNITS_FIELD, MAXIMUM_UNITS_FIELD, SCALING_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScalingSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean autoScalingDisabled;
    private final Long minimumUnits;
    private final Long maximumUnits;
    private final AutoScalingPolicy scalingPolicy;

    private AutoScalingSettings(BuilderImpl builder) {
        this.autoScalingDisabled = builder.autoScalingDisabled;
        this.minimumUnits = builder.minimumUnits;
        this.maximumUnits = builder.maximumUnits;
        this.scalingPolicy = builder.scalingPolicy;
    }

    public final Boolean autoScalingDisabled() {
        return this.autoScalingDisabled;
    }

    public final Long minimumUnits() {
        return this.minimumUnits;
    }

    public final Long maximumUnits() {
        return this.maximumUnits;
    }

    public final AutoScalingPolicy scalingPolicy() {
        return this.scalingPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingSettings)) {
            return false;
        }
        AutoScalingSettings other = (AutoScalingSettings)obj;
        return Objects.equals(this.autoScalingDisabled(), other.autoScalingDisabled()) && Objects.equals(this.minimumUnits(), other.minimumUnits()) && Objects.equals(this.maximumUnits(), other.maximumUnits()) && Objects.equals(this.scalingPolicy(), other.scalingPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingSettings").add("AutoScalingDisabled", (Object)this.autoScalingDisabled()).add("MinimumUnits", (Object)this.minimumUnits()).add("MaximumUnits", (Object)this.maximumUnits()).add("ScalingPolicy", (Object)this.scalingPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoScalingDisabled": {
                return Optional.ofNullable(clazz.cast(this.autoScalingDisabled()));
            }
            case "minimumUnits": {
                return Optional.ofNullable(clazz.cast(this.minimumUnits()));
            }
            case "maximumUnits": {
                return Optional.ofNullable(clazz.cast(this.maximumUnits()));
            }
            case "scalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoScalingDisabled", AUTO_SCALING_DISABLED_FIELD);
        map.put("minimumUnits", MINIMUM_UNITS_FIELD);
        map.put("maximumUnits", MAXIMUM_UNITS_FIELD);
        map.put("scalingPolicy", SCALING_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingSettings, T> g) {
        return obj -> g.apply((AutoScalingSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean autoScalingDisabled;
        private Long minimumUnits;
        private Long maximumUnits;
        private AutoScalingPolicy scalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingSettings model) {
            this.autoScalingDisabled(model.autoScalingDisabled);
            this.minimumUnits(model.minimumUnits);
            this.maximumUnits(model.maximumUnits);
            this.scalingPolicy(model.scalingPolicy);
        }

        public final Boolean getAutoScalingDisabled() {
            return this.autoScalingDisabled;
        }

        public final void setAutoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
        }

        @Override
        public final Builder autoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
            return this;
        }

        public final Long getMinimumUnits() {
            return this.minimumUnits;
        }

        public final void setMinimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
        }

        @Override
        public final Builder minimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
            return this;
        }

        public final Long getMaximumUnits() {
            return this.maximumUnits;
        }

        public final void setMaximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
        }

        @Override
        public final Builder maximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
            return this;
        }

        public final AutoScalingPolicy.Builder getScalingPolicy() {
            return this.scalingPolicy != null ? this.scalingPolicy.toBuilder() : null;
        }

        public final void setScalingPolicy(AutoScalingPolicy.BuilderImpl scalingPolicy) {
            this.scalingPolicy = scalingPolicy != null ? scalingPolicy.build() : null;
        }

        @Override
        public final Builder scalingPolicy(AutoScalingPolicy scalingPolicy) {
            this.scalingPolicy = scalingPolicy;
            return this;
        }

        public AutoScalingSettings build() {
            return new AutoScalingSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingSettings> {
        public Builder autoScalingDisabled(Boolean var1);

        public Builder minimumUnits(Long var1);

        public Builder maximumUnits(Long var1);

        public Builder scalingPolicy(AutoScalingPolicy var1);

        default public Builder scalingPolicy(Consumer<AutoScalingPolicy.Builder> scalingPolicy) {
            return this.scalingPolicy((AutoScalingPolicy)((AutoScalingPolicy.Builder)AutoScalingPolicy.builder().applyMutation(scalingPolicy)).build());
        }
    }
}

