/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideowebrtcstorage;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.KinesisVideoWebRtcStorageClient;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.KinesisVideoWebRtcStorageServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.internal.KinesisVideoWebRtcStorageServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.AccessDeniedException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.JoinStorageSessionAsViewerRequest;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.JoinStorageSessionAsViewerResponse;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.JoinStorageSessionRequest;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.JoinStorageSessionResponse;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.KinesisVideoWebRtcStorageException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.transform.JoinStorageSessionAsViewerRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideowebrtcstorage.transform.JoinStorageSessionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKinesisVideoWebRtcStorageClient
implements KinesisVideoWebRtcStorageClient {
    private static final Logger log = Logger.loggerFor(DefaultKinesisVideoWebRtcStorageClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisVideoWebRtcStorageClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Kinesis_Video_WebRTC_Storage#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JoinStorageSessionResponse joinStorageSession(JoinStorageSessionRequest joinStorageSessionRequest) throws ClientLimitExceededException, InvalidArgumentException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisVideoWebRtcStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, JoinStorageSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)joinStorageSessionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoWebRtcStorageClient.resolveMetricPublishers(clientConfiguration, joinStorageSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video WebRTC Storage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"JoinStorageSession");
            JoinStorageSessionResponse joinStorageSessionResponse = (JoinStorageSessionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("JoinStorageSession").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)joinStorageSessionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new JoinStorageSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return joinStorageSessionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoWebRtcStorageClient.lambda$joinStorageSession$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JoinStorageSessionAsViewerResponse joinStorageSessionAsViewer(JoinStorageSessionAsViewerRequest joinStorageSessionAsViewerRequest) throws ClientLimitExceededException, InvalidArgumentException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, KinesisVideoWebRtcStorageException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, JoinStorageSessionAsViewerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)joinStorageSessionAsViewerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoWebRtcStorageClient.resolveMetricPublishers(clientConfiguration, joinStorageSessionAsViewerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video WebRTC Storage");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"JoinStorageSessionAsViewer");
            JoinStorageSessionAsViewerResponse joinStorageSessionAsViewerResponse = (JoinStorageSessionAsViewerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("JoinStorageSessionAsViewer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)joinStorageSessionAsViewerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new JoinStorageSessionAsViewerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return joinStorageSessionAsViewerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoWebRtcStorageClient.lambda$joinStorageSessionAsViewer$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "kinesisvideo";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KinesisVideoWebRtcStorageServiceClientConfigurationBuilder serviceConfigBuilder = new KinesisVideoWebRtcStorageServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisVideoWebRtcStorageException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final KinesisVideoWebRtcStorageServiceClientConfiguration serviceClientConfiguration() {
        return new KinesisVideoWebRtcStorageServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$joinStorageSessionAsViewer$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$joinStorageSession$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

