/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.CallbackDetails;
import software.amazon.awssdk.services.lambda.model.ChainedInvokeDetails;
import software.amazon.awssdk.services.lambda.model.ContextDetails;
import software.amazon.awssdk.services.lambda.model.ExecutionDetails;
import software.amazon.awssdk.services.lambda.model.OperationStatus;
import software.amazon.awssdk.services.lambda.model.OperationType;
import software.amazon.awssdk.services.lambda.model.StepDetails;
import software.amazon.awssdk.services.lambda.model.WaitDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Operation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Operation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Operation.getter(Operation::id)).setter(Operation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentId").getter(Operation.getter(Operation::parentId)).setter(Operation.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Operation.getter(Operation::name)).setter(Operation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Operation.getter(Operation::typeAsString)).setter(Operation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubType").getter(Operation.getter(Operation::subType)).setter(Operation.setter(Builder::subType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(Operation.getter(Operation::startTimestamp)).setter(Operation.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(Operation.getter(Operation::endTimestamp)).setter(Operation.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Operation.getter(Operation::statusAsString)).setter(Operation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ExecutionDetails> EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionDetails").getter(Operation.getter(Operation::executionDetails)).setter(Operation.setter(Builder::executionDetails)).constructor(ExecutionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionDetails").build()}).build();
    private static final SdkField<ContextDetails> CONTEXT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContextDetails").getter(Operation.getter(Operation::contextDetails)).setter(Operation.setter(Builder::contextDetails)).constructor(ContextDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextDetails").build()}).build();
    private static final SdkField<StepDetails> STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepDetails").getter(Operation.getter(Operation::stepDetails)).setter(Operation.setter(Builder::stepDetails)).constructor(StepDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepDetails").build()}).build();
    private static final SdkField<WaitDetails> WAIT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WaitDetails").getter(Operation.getter(Operation::waitDetails)).setter(Operation.setter(Builder::waitDetails)).constructor(WaitDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitDetails").build()}).build();
    private static final SdkField<CallbackDetails> CALLBACK_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CallbackDetails").getter(Operation.getter(Operation::callbackDetails)).setter(Operation.setter(Builder::callbackDetails)).constructor(CallbackDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackDetails").build()}).build();
    private static final SdkField<ChainedInvokeDetails> CHAINED_INVOKE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChainedInvokeDetails").getter(Operation.getter(Operation::chainedInvokeDetails)).setter(Operation.setter(Builder::chainedInvokeDetails)).constructor(ChainedInvokeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PARENT_ID_FIELD, NAME_FIELD, TYPE_FIELD, SUB_TYPE_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, STATUS_FIELD, EXECUTION_DETAILS_FIELD, CONTEXT_DETAILS_FIELD, STEP_DETAILS_FIELD, WAIT_DETAILS_FIELD, CALLBACK_DETAILS_FIELD, CHAINED_INVOKE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Operation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String parentId;
    private final String name;
    private final String type;
    private final String subType;
    private final Instant startTimestamp;
    private final Instant endTimestamp;
    private final String status;
    private final ExecutionDetails executionDetails;
    private final ContextDetails contextDetails;
    private final StepDetails stepDetails;
    private final WaitDetails waitDetails;
    private final CallbackDetails callbackDetails;
    private final ChainedInvokeDetails chainedInvokeDetails;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.name = builder.name;
        this.type = builder.type;
        this.subType = builder.subType;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.status = builder.status;
        this.executionDetails = builder.executionDetails;
        this.contextDetails = builder.contextDetails;
        this.stepDetails = builder.stepDetails;
        this.waitDetails = builder.waitDetails;
        this.callbackDetails = builder.callbackDetails;
        this.chainedInvokeDetails = builder.chainedInvokeDetails;
    }

    public final String id() {
        return this.id;
    }

    public final String parentId() {
        return this.parentId;
    }

    public final String name() {
        return this.name;
    }

    public final OperationType type() {
        return OperationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String subType() {
        return this.subType;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public final OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ExecutionDetails executionDetails() {
        return this.executionDetails;
    }

    public final ContextDetails contextDetails() {
        return this.contextDetails;
    }

    public final StepDetails stepDetails() {
        return this.stepDetails;
    }

    public final WaitDetails waitDetails() {
        return this.waitDetails;
    }

    public final CallbackDetails callbackDetails() {
        return this.callbackDetails;
    }

    public final ChainedInvokeDetails chainedInvokeDetails() {
        return this.chainedInvokeDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subType());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.chainedInvokeDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.subType(), other.subType()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.executionDetails(), other.executionDetails()) && Objects.equals(this.contextDetails(), other.contextDetails()) && Objects.equals(this.stepDetails(), other.stepDetails()) && Objects.equals(this.waitDetails(), other.waitDetails()) && Objects.equals(this.callbackDetails(), other.callbackDetails()) && Objects.equals(this.chainedInvokeDetails(), other.chainedInvokeDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Operation").add("Id", (Object)this.id()).add("ParentId", (Object)this.parentId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("SubType", (Object)this.subType()).add("StartTimestamp", (Object)this.startTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).add("Status", (Object)this.statusAsString()).add("ExecutionDetails", (Object)this.executionDetails()).add("ContextDetails", (Object)this.contextDetails()).add("StepDetails", (Object)this.stepDetails()).add("WaitDetails", (Object)this.waitDetails()).add("CallbackDetails", (Object)this.callbackDetails()).add("ChainedInvokeDetails", (Object)this.chainedInvokeDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SubType": {
                return Optional.ofNullable(clazz.cast(this.subType()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ExecutionDetails": {
                return Optional.ofNullable(clazz.cast(this.executionDetails()));
            }
            case "ContextDetails": {
                return Optional.ofNullable(clazz.cast(this.contextDetails()));
            }
            case "StepDetails": {
                return Optional.ofNullable(clazz.cast(this.stepDetails()));
            }
            case "WaitDetails": {
                return Optional.ofNullable(clazz.cast(this.waitDetails()));
            }
            case "CallbackDetails": {
                return Optional.ofNullable(clazz.cast(this.callbackDetails()));
            }
            case "ChainedInvokeDetails": {
                return Optional.ofNullable(clazz.cast(this.chainedInvokeDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ParentId", PARENT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ExecutionDetails", EXECUTION_DETAILS_FIELD);
        map.put("ContextDetails", CONTEXT_DETAILS_FIELD);
        map.put("StepDetails", STEP_DETAILS_FIELD);
        map.put("WaitDetails", WAIT_DETAILS_FIELD);
        map.put("CallbackDetails", CALLBACK_DETAILS_FIELD);
        map.put("ChainedInvokeDetails", CHAINED_INVOKE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Operation, T> g) {
        return obj -> g.apply((Operation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String parentId;
        private String name;
        private String type;
        private String subType;
        private Instant startTimestamp;
        private Instant endTimestamp;
        private String status;
        private ExecutionDetails executionDetails;
        private ContextDetails contextDetails;
        private StepDetails stepDetails;
        private WaitDetails waitDetails;
        private CallbackDetails callbackDetails;
        private ChainedInvokeDetails chainedInvokeDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            this.id(model.id);
            this.parentId(model.parentId);
            this.name(model.name);
            this.type(model.type);
            this.subType(model.subType);
            this.startTimestamp(model.startTimestamp);
            this.endTimestamp(model.endTimestamp);
            this.status(model.status);
            this.executionDetails(model.executionDetails);
            this.contextDetails(model.contextDetails);
            this.stepDetails(model.stepDetails);
            this.waitDetails(model.waitDetails);
            this.callbackDetails(model.callbackDetails);
            this.chainedInvokeDetails(model.chainedInvokeDetails);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParentId() {
            return this.parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ExecutionDetails.Builder getExecutionDetails() {
            return this.executionDetails != null ? this.executionDetails.toBuilder() : null;
        }

        public final void setExecutionDetails(ExecutionDetails.BuilderImpl executionDetails) {
            this.executionDetails = executionDetails != null ? executionDetails.build() : null;
        }

        @Override
        public final Builder executionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails;
            return this;
        }

        public final ContextDetails.Builder getContextDetails() {
            return this.contextDetails != null ? this.contextDetails.toBuilder() : null;
        }

        public final void setContextDetails(ContextDetails.BuilderImpl contextDetails) {
            this.contextDetails = contextDetails != null ? contextDetails.build() : null;
        }

        @Override
        public final Builder contextDetails(ContextDetails contextDetails) {
            this.contextDetails = contextDetails;
            return this;
        }

        public final StepDetails.Builder getStepDetails() {
            return this.stepDetails != null ? this.stepDetails.toBuilder() : null;
        }

        public final void setStepDetails(StepDetails.BuilderImpl stepDetails) {
            this.stepDetails = stepDetails != null ? stepDetails.build() : null;
        }

        @Override
        public final Builder stepDetails(StepDetails stepDetails) {
            this.stepDetails = stepDetails;
            return this;
        }

        public final WaitDetails.Builder getWaitDetails() {
            return this.waitDetails != null ? this.waitDetails.toBuilder() : null;
        }

        public final void setWaitDetails(WaitDetails.BuilderImpl waitDetails) {
            this.waitDetails = waitDetails != null ? waitDetails.build() : null;
        }

        @Override
        public final Builder waitDetails(WaitDetails waitDetails) {
            this.waitDetails = waitDetails;
            return this;
        }

        public final CallbackDetails.Builder getCallbackDetails() {
            return this.callbackDetails != null ? this.callbackDetails.toBuilder() : null;
        }

        public final void setCallbackDetails(CallbackDetails.BuilderImpl callbackDetails) {
            this.callbackDetails = callbackDetails != null ? callbackDetails.build() : null;
        }

        @Override
        public final Builder callbackDetails(CallbackDetails callbackDetails) {
            this.callbackDetails = callbackDetails;
            return this;
        }

        public final ChainedInvokeDetails.Builder getChainedInvokeDetails() {
            return this.chainedInvokeDetails != null ? this.chainedInvokeDetails.toBuilder() : null;
        }

        public final void setChainedInvokeDetails(ChainedInvokeDetails.BuilderImpl chainedInvokeDetails) {
            this.chainedInvokeDetails = chainedInvokeDetails != null ? chainedInvokeDetails.build() : null;
        }

        @Override
        public final Builder chainedInvokeDetails(ChainedInvokeDetails chainedInvokeDetails) {
            this.chainedInvokeDetails = chainedInvokeDetails;
            return this;
        }

        public Operation build() {
            return new Operation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Operation> {
        public Builder id(String var1);

        public Builder parentId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(OperationType var1);

        public Builder subType(String var1);

        public Builder startTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder executionDetails(ExecutionDetails var1);

        default public Builder executionDetails(Consumer<ExecutionDetails.Builder> executionDetails) {
            return this.executionDetails((ExecutionDetails)((ExecutionDetails.Builder)ExecutionDetails.builder().applyMutation(executionDetails)).build());
        }

        public Builder contextDetails(ContextDetails var1);

        default public Builder contextDetails(Consumer<ContextDetails.Builder> contextDetails) {
            return this.contextDetails((ContextDetails)((ContextDetails.Builder)ContextDetails.builder().applyMutation(contextDetails)).build());
        }

        public Builder stepDetails(StepDetails var1);

        default public Builder stepDetails(Consumer<StepDetails.Builder> stepDetails) {
            return this.stepDetails((StepDetails)((StepDetails.Builder)StepDetails.builder().applyMutation(stepDetails)).build());
        }

        public Builder waitDetails(WaitDetails var1);

        default public Builder waitDetails(Consumer<WaitDetails.Builder> waitDetails) {
            return this.waitDetails((WaitDetails)((WaitDetails.Builder)WaitDetails.builder().applyMutation(waitDetails)).build());
        }

        public Builder callbackDetails(CallbackDetails var1);

        default public Builder callbackDetails(Consumer<CallbackDetails.Builder> callbackDetails) {
            return this.callbackDetails((CallbackDetails)((CallbackDetails.Builder)CallbackDetails.builder().applyMutation(callbackDetails)).build());
        }

        public Builder chainedInvokeDetails(ChainedInvokeDetails var1);

        default public Builder chainedInvokeDetails(Consumer<ChainedInvokeDetails.Builder> chainedInvokeDetails) {
            return this.chainedInvokeDetails((ChainedInvokeDetails)((ChainedInvokeDetails.Builder)ChainedInvokeDetails.builder().applyMutation(chainedInvokeDetails)).build());
        }
    }
}

