/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationStatus {
    STARTED("STARTED"),
    PENDING("PENDING"),
    READY("READY"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    CANCELLED("CANCELLED"),
    TIMED_OUT("TIMED_OUT"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationStatus> VALUE_MAP;
    private final String value;

    private OperationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationStatus> knownValues() {
        EnumSet<OperationStatus> knownValues = EnumSet.allOf(OperationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationStatus.class, OperationStatus::toString);
    }
}

