/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFunctionCodeSigningConfigResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, PutFunctionCodeSigningConfigResponse> {
    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSigningConfigArn").getter(PutFunctionCodeSigningConfigResponse.getter(PutFunctionCodeSigningConfigResponse::codeSigningConfigArn)).setter(PutFunctionCodeSigningConfigResponse.setter(Builder::codeSigningConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigArn").build()}).build();
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(PutFunctionCodeSigningConfigResponse.getter(PutFunctionCodeSigningConfigResponse::functionName)).setter(PutFunctionCodeSigningConfigResponse.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SIGNING_CONFIG_ARN_FIELD, FUNCTION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutFunctionCodeSigningConfigResponse.memberNameToFieldInitializer();
    private final String codeSigningConfigArn;
    private final String functionName;

    private PutFunctionCodeSigningConfigResponse(BuilderImpl builder) {
        super(builder);
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
        this.functionName = builder.functionName;
    }

    public final String codeSigningConfigArn() {
        return this.codeSigningConfigArn;
    }

    public final String functionName() {
        return this.functionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionCodeSigningConfigResponse)) {
            return false;
        }
        PutFunctionCodeSigningConfigResponse other = (PutFunctionCodeSigningConfigResponse)((Object)obj);
        return Objects.equals(this.codeSigningConfigArn(), other.codeSigningConfigArn()) && Objects.equals(this.functionName(), other.functionName());
    }

    public final String toString() {
        return ToString.builder((String)"PutFunctionCodeSigningConfigResponse").add("CodeSigningConfigArn", (Object)this.codeSigningConfigArn()).add("FunctionName", (Object)this.functionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeSigningConfigArn": {
                return Optional.ofNullable(clazz.cast(this.codeSigningConfigArn()));
            }
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CodeSigningConfigArn", CODE_SIGNING_CONFIG_ARN_FIELD);
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionCodeSigningConfigResponse, T> g) {
        return obj -> g.apply((PutFunctionCodeSigningConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String codeSigningConfigArn;
        private String functionName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionCodeSigningConfigResponse model) {
            super(model);
            this.codeSigningConfigArn(model.codeSigningConfigArn);
            this.functionName(model.functionName);
        }

        public final String getCodeSigningConfigArn() {
            return this.codeSigningConfigArn;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        @Override
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        @Override
        public PutFunctionCodeSigningConfigResponse build() {
            return new PutFunctionCodeSigningConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutFunctionCodeSigningConfigResponse> {
        public Builder codeSigningConfigArn(String var1);

        public Builder functionName(String var1);
    }
}

