/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.launchwizard.LaunchWizardAsyncClient;
import software.amazon.awssdk.services.launchwizard.internal.UserAgentUtils;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListWorkloadDeploymentPatternsResponse;
import software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternDataSummary;

public class ListWorkloadDeploymentPatternsPublisher
implements SdkPublisher<ListWorkloadDeploymentPatternsResponse> {
    private final LaunchWizardAsyncClient client;
    private final ListWorkloadDeploymentPatternsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkloadDeploymentPatternsPublisher(LaunchWizardAsyncClient client, ListWorkloadDeploymentPatternsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkloadDeploymentPatternsPublisher(LaunchWizardAsyncClient client, ListWorkloadDeploymentPatternsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkloadDeploymentPatternsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkloadDeploymentPatternsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns() {
        Function<ListWorkloadDeploymentPatternsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workloadDeploymentPatterns() != null) {
                return response.workloadDeploymentPatterns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkloadDeploymentPatternsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkloadDeploymentPatternsResponseFetcher
    implements AsyncPageFetcher<ListWorkloadDeploymentPatternsResponse> {
        private ListWorkloadDeploymentPatternsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadDeploymentPatternsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkloadDeploymentPatternsResponse> nextPage(ListWorkloadDeploymentPatternsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadDeploymentPatternsPublisher.this.client.listWorkloadDeploymentPatterns(ListWorkloadDeploymentPatternsPublisher.this.firstRequest);
            }
            return ListWorkloadDeploymentPatternsPublisher.this.client.listWorkloadDeploymentPatterns((ListWorkloadDeploymentPatternsRequest)((Object)ListWorkloadDeploymentPatternsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

