/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRouterInputResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, CreateRouterInputResponse> {
    private static final SdkField<RouterInput> ROUTER_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouterInput").getter(CreateRouterInputResponse.getter(CreateRouterInputResponse::routerInput)).setter(CreateRouterInputResponse.setter(Builder::routerInput)).constructor(RouterInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRouterInputResponse.memberNameToFieldInitializer();
    private final RouterInput routerInput;

    private CreateRouterInputResponse(BuilderImpl builder) {
        super(builder);
        this.routerInput = builder.routerInput;
    }

    public final RouterInput routerInput() {
        return this.routerInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.routerInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouterInputResponse)) {
            return false;
        }
        CreateRouterInputResponse other = (CreateRouterInputResponse)((Object)obj);
        return Objects.equals(this.routerInput(), other.routerInput());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRouterInputResponse").add("RouterInput", (Object)this.routerInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouterInput": {
                return Optional.ofNullable(clazz.cast(this.routerInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<RouterInput>> map = new HashMap<String, SdkField<RouterInput>>();
        map.put("routerInput", ROUTER_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRouterInputResponse, T> g) {
        return obj -> g.apply((CreateRouterInputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private RouterInput routerInput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouterInputResponse model) {
            super(model);
            this.routerInput(model.routerInput);
        }

        public final RouterInput.Builder getRouterInput() {
            return this.routerInput != null ? this.routerInput.toBuilder() : null;
        }

        public final void setRouterInput(RouterInput.BuilderImpl routerInput) {
            this.routerInput = routerInput != null ? routerInput.build() : null;
        }

        @Override
        public final Builder routerInput(RouterInput routerInput) {
            this.routerInput = routerInput;
            return this;
        }

        @Override
        public CreateRouterInputResponse build() {
            return new CreateRouterInputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRouterInputResponse> {
        public Builder routerInput(RouterInput var1);

        default public Builder routerInput(Consumer<RouterInput.Builder> routerInput) {
            return this.routerInput((RouterInput)((RouterInput.Builder)RouterInput.builder().applyMutation(routerInput)).build());
        }
    }
}

