/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceSchedule;
import software.amazon.awssdk.services.mediaconnect.model.MaintenanceScheduleType;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputRoutedState;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputState;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputType;
import software.amazon.awssdk.services.mediaconnect.model.RoutingScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedRouterOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedRouterOutput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ListedRouterOutput.getter(ListedRouterOutput::name)).setter(ListedRouterOutput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListedRouterOutput.getter(ListedRouterOutput::arn)).setter(ListedRouterOutput.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ListedRouterOutput.getter(ListedRouterOutput::id)).setter(ListedRouterOutput.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputType").getter(ListedRouterOutput.getter(ListedRouterOutput::outputTypeAsString)).setter(ListedRouterOutput.setter(Builder::outputType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ListedRouterOutput.getter(ListedRouterOutput::stateAsString)).setter(ListedRouterOutput.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> ROUTED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutedState").getter(ListedRouterOutput.getter(ListedRouterOutput::routedStateAsString)).setter(ListedRouterOutput.setter(Builder::routedState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedState").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(ListedRouterOutput.getter(ListedRouterOutput::regionName)).setter(ListedRouterOutput.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ListedRouterOutput.getter(ListedRouterOutput::availabilityZone)).setter(ListedRouterOutput.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<Long> MAXIMUM_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaximumBitrate").getter(ListedRouterOutput.getter(ListedRouterOutput::maximumBitrate)).setter(ListedRouterOutput.setter(Builder::maximumBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumBitrate").build()}).build();
    private static final SdkField<String> ROUTING_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingScope").getter(ListedRouterOutput.getter(ListedRouterOutput::routingScopeAsString)).setter(ListedRouterOutput.setter(Builder::routingScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingScope").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ListedRouterOutput.getter(ListedRouterOutput::createdAt)).setter(ListedRouterOutput.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ListedRouterOutput.getter(ListedRouterOutput::updatedAt)).setter(ListedRouterOutput.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> MESSAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MessageCount").getter(ListedRouterOutput.getter(ListedRouterOutput::messageCount)).setter(ListedRouterOutput.setter(Builder::messageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageCount").build()}).build();
    private static final SdkField<String> ROUTED_INPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutedInputArn").getter(ListedRouterOutput.getter(ListedRouterOutput::routedInputArn)).setter(ListedRouterOutput.setter(Builder::routedInputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routedInputArn").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceArn").getter(ListedRouterOutput.getter(ListedRouterOutput::networkInterfaceArn)).setter(ListedRouterOutput.setter(Builder::networkInterfaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build()}).build();
    private static final SdkField<String> MAINTENANCE_SCHEDULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceScheduleType").getter(ListedRouterOutput.getter(ListedRouterOutput::maintenanceScheduleTypeAsString)).setter(ListedRouterOutput.setter(Builder::maintenanceScheduleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceScheduleType").build()}).build();
    private static final SdkField<MaintenanceSchedule> MAINTENANCE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceSchedule").getter(ListedRouterOutput.getter(ListedRouterOutput::maintenanceSchedule)).setter(ListedRouterOutput.setter(Builder::maintenanceSchedule)).constructor(MaintenanceSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceSchedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ID_FIELD, OUTPUT_TYPE_FIELD, STATE_FIELD, ROUTED_STATE_FIELD, REGION_NAME_FIELD, AVAILABILITY_ZONE_FIELD, MAXIMUM_BITRATE_FIELD, ROUTING_SCOPE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, MESSAGE_COUNT_FIELD, ROUTED_INPUT_ARN_FIELD, NETWORK_INTERFACE_ARN_FIELD, MAINTENANCE_SCHEDULE_TYPE_FIELD, MAINTENANCE_SCHEDULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListedRouterOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String id;
    private final String outputType;
    private final String state;
    private final String routedState;
    private final String regionName;
    private final String availabilityZone;
    private final Long maximumBitrate;
    private final String routingScope;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Integer messageCount;
    private final String routedInputArn;
    private final String networkInterfaceArn;
    private final String maintenanceScheduleType;
    private final MaintenanceSchedule maintenanceSchedule;

    private ListedRouterOutput(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.outputType = builder.outputType;
        this.state = builder.state;
        this.routedState = builder.routedState;
        this.regionName = builder.regionName;
        this.availabilityZone = builder.availabilityZone;
        this.maximumBitrate = builder.maximumBitrate;
        this.routingScope = builder.routingScope;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.messageCount = builder.messageCount;
        this.routedInputArn = builder.routedInputArn;
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.maintenanceScheduleType = builder.maintenanceScheduleType;
        this.maintenanceSchedule = builder.maintenanceSchedule;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final RouterOutputType outputType() {
        return RouterOutputType.fromValue(this.outputType);
    }

    public final String outputTypeAsString() {
        return this.outputType;
    }

    public final RouterOutputState state() {
        return RouterOutputState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final RouterOutputRoutedState routedState() {
        return RouterOutputRoutedState.fromValue(this.routedState);
    }

    public final String routedStateAsString() {
        return this.routedState;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Long maximumBitrate() {
        return this.maximumBitrate;
    }

    public final RoutingScope routingScope() {
        return RoutingScope.fromValue(this.routingScope);
    }

    public final String routingScopeAsString() {
        return this.routingScope;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Integer messageCount() {
        return this.messageCount;
    }

    public final String routedInputArn() {
        return this.routedInputArn;
    }

    public final String networkInterfaceArn() {
        return this.networkInterfaceArn;
    }

    public final MaintenanceScheduleType maintenanceScheduleType() {
        return MaintenanceScheduleType.fromValue(this.maintenanceScheduleType);
    }

    public final String maintenanceScheduleTypeAsString() {
        return this.maintenanceScheduleType;
    }

    public final MaintenanceSchedule maintenanceSchedule() {
        return this.maintenanceSchedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routedStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.routedInputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceScheduleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceSchedule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedRouterOutput)) {
            return false;
        }
        ListedRouterOutput other = (ListedRouterOutput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.outputTypeAsString(), other.outputTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.routedStateAsString(), other.routedStateAsString()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.maximumBitrate(), other.maximumBitrate()) && Objects.equals(this.routingScopeAsString(), other.routingScopeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.messageCount(), other.messageCount()) && Objects.equals(this.routedInputArn(), other.routedInputArn()) && Objects.equals(this.networkInterfaceArn(), other.networkInterfaceArn()) && Objects.equals(this.maintenanceScheduleTypeAsString(), other.maintenanceScheduleTypeAsString()) && Objects.equals(this.maintenanceSchedule(), other.maintenanceSchedule());
    }

    public final String toString() {
        return ToString.builder((String)"ListedRouterOutput").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("OutputType", (Object)this.outputTypeAsString()).add("State", (Object)this.stateAsString()).add("RoutedState", (Object)this.routedStateAsString()).add("RegionName", (Object)this.regionName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("MaximumBitrate", (Object)this.maximumBitrate()).add("RoutingScope", (Object)this.routingScopeAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("MessageCount", (Object)this.messageCount()).add("RoutedInputArn", (Object)this.routedInputArn()).add("NetworkInterfaceArn", (Object)this.networkInterfaceArn()).add("MaintenanceScheduleType", (Object)this.maintenanceScheduleTypeAsString()).add("MaintenanceSchedule", (Object)this.maintenanceSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OutputType": {
                return Optional.ofNullable(clazz.cast(this.outputTypeAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "RoutedState": {
                return Optional.ofNullable(clazz.cast(this.routedStateAsString()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "MaximumBitrate": {
                return Optional.ofNullable(clazz.cast(this.maximumBitrate()));
            }
            case "RoutingScope": {
                return Optional.ofNullable(clazz.cast(this.routingScopeAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "MessageCount": {
                return Optional.ofNullable(clazz.cast(this.messageCount()));
            }
            case "RoutedInputArn": {
                return Optional.ofNullable(clazz.cast(this.routedInputArn()));
            }
            case "NetworkInterfaceArn": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceArn()));
            }
            case "MaintenanceScheduleType": {
                return Optional.ofNullable(clazz.cast(this.maintenanceScheduleTypeAsString()));
            }
            case "MaintenanceSchedule": {
                return Optional.ofNullable(clazz.cast(this.maintenanceSchedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("outputType", OUTPUT_TYPE_FIELD);
        map.put("state", STATE_FIELD);
        map.put("routedState", ROUTED_STATE_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("maximumBitrate", MAXIMUM_BITRATE_FIELD);
        map.put("routingScope", ROUTING_SCOPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("messageCount", MESSAGE_COUNT_FIELD);
        map.put("routedInputArn", ROUTED_INPUT_ARN_FIELD);
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("maintenanceScheduleType", MAINTENANCE_SCHEDULE_TYPE_FIELD);
        map.put("maintenanceSchedule", MAINTENANCE_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedRouterOutput, T> g) {
        return obj -> g.apply((ListedRouterOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String id;
        private String outputType;
        private String state;
        private String routedState;
        private String regionName;
        private String availabilityZone;
        private Long maximumBitrate;
        private String routingScope;
        private Instant createdAt;
        private Instant updatedAt;
        private Integer messageCount;
        private String routedInputArn;
        private String networkInterfaceArn;
        private String maintenanceScheduleType;
        private MaintenanceSchedule maintenanceSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedRouterOutput model) {
            this.name(model.name);
            this.arn(model.arn);
            this.id(model.id);
            this.outputType(model.outputType);
            this.state(model.state);
            this.routedState(model.routedState);
            this.regionName(model.regionName);
            this.availabilityZone(model.availabilityZone);
            this.maximumBitrate(model.maximumBitrate);
            this.routingScope(model.routingScope);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.messageCount(model.messageCount);
            this.routedInputArn(model.routedInputArn);
            this.networkInterfaceArn(model.networkInterfaceArn);
            this.maintenanceScheduleType(model.maintenanceScheduleType);
            this.maintenanceSchedule(model.maintenanceSchedule);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOutputType() {
            return this.outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        @Override
        public final Builder outputType(RouterOutputType outputType) {
            this.outputType(outputType == null ? null : outputType.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouterOutputState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRoutedState() {
            return this.routedState;
        }

        public final void setRoutedState(String routedState) {
            this.routedState = routedState;
        }

        @Override
        public final Builder routedState(String routedState) {
            this.routedState = routedState;
            return this;
        }

        @Override
        public final Builder routedState(RouterOutputRoutedState routedState) {
            this.routedState(routedState == null ? null : routedState.toString());
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getMaximumBitrate() {
            return this.maximumBitrate;
        }

        public final void setMaximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
        }

        @Override
        public final Builder maximumBitrate(Long maximumBitrate) {
            this.maximumBitrate = maximumBitrate;
            return this;
        }

        public final String getRoutingScope() {
            return this.routingScope;
        }

        public final void setRoutingScope(String routingScope) {
            this.routingScope = routingScope;
        }

        @Override
        public final Builder routingScope(String routingScope) {
            this.routingScope = routingScope;
            return this;
        }

        @Override
        public final Builder routingScope(RoutingScope routingScope) {
            this.routingScope(routingScope == null ? null : routingScope.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Integer getMessageCount() {
            return this.messageCount;
        }

        public final void setMessageCount(Integer messageCount) {
            this.messageCount = messageCount;
        }

        @Override
        public final Builder messageCount(Integer messageCount) {
            this.messageCount = messageCount;
            return this;
        }

        public final String getRoutedInputArn() {
            return this.routedInputArn;
        }

        public final void setRoutedInputArn(String routedInputArn) {
            this.routedInputArn = routedInputArn;
        }

        @Override
        public final Builder routedInputArn(String routedInputArn) {
            this.routedInputArn = routedInputArn;
            return this;
        }

        public final String getNetworkInterfaceArn() {
            return this.networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final String getMaintenanceScheduleType() {
            return this.maintenanceScheduleType;
        }

        public final void setMaintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
        }

        @Override
        public final Builder maintenanceScheduleType(String maintenanceScheduleType) {
            this.maintenanceScheduleType = maintenanceScheduleType;
            return this;
        }

        @Override
        public final Builder maintenanceScheduleType(MaintenanceScheduleType maintenanceScheduleType) {
            this.maintenanceScheduleType(maintenanceScheduleType == null ? null : maintenanceScheduleType.toString());
            return this;
        }

        public final MaintenanceSchedule.Builder getMaintenanceSchedule() {
            return this.maintenanceSchedule != null ? this.maintenanceSchedule.toBuilder() : null;
        }

        public final void setMaintenanceSchedule(MaintenanceSchedule.BuilderImpl maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule != null ? maintenanceSchedule.build() : null;
        }

        @Override
        public final Builder maintenanceSchedule(MaintenanceSchedule maintenanceSchedule) {
            this.maintenanceSchedule = maintenanceSchedule;
            return this;
        }

        public ListedRouterOutput build() {
            return new ListedRouterOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedRouterOutput> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder outputType(String var1);

        public Builder outputType(RouterOutputType var1);

        public Builder state(String var1);

        public Builder state(RouterOutputState var1);

        public Builder routedState(String var1);

        public Builder routedState(RouterOutputRoutedState var1);

        public Builder regionName(String var1);

        public Builder availabilityZone(String var1);

        public Builder maximumBitrate(Long var1);

        public Builder routingScope(String var1);

        public Builder routingScope(RoutingScope var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder messageCount(Integer var1);

        public Builder routedInputArn(String var1);

        public Builder networkInterfaceArn(String var1);

        public Builder maintenanceScheduleType(String var1);

        public Builder maintenanceScheduleType(MaintenanceScheduleType var1);

        public Builder maintenanceSchedule(MaintenanceSchedule var1);

        default public Builder maintenanceSchedule(Consumer<MaintenanceSchedule.Builder> maintenanceSchedule) {
            return this.maintenanceSchedule((MaintenanceSchedule)((MaintenanceSchedule.Builder)MaintenanceSchedule.builder().applyMutation(maintenanceSchedule)).build());
        }
    }
}

