/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaLiveInputPipelineId;
import software.amazon.awssdk.services.mediaconnect.model.MediaLiveTransitEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaLiveInputRouterOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaLiveInputRouterOutputConfiguration> {
    private static final SdkField<String> MEDIA_LIVE_INPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaLiveInputArn").getter(MediaLiveInputRouterOutputConfiguration.getter(MediaLiveInputRouterOutputConfiguration::mediaLiveInputArn)).setter(MediaLiveInputRouterOutputConfiguration.setter(Builder::mediaLiveInputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaLiveInputArn").build()}).build();
    private static final SdkField<String> MEDIA_LIVE_PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaLivePipelineId").getter(MediaLiveInputRouterOutputConfiguration.getter(MediaLiveInputRouterOutputConfiguration::mediaLivePipelineIdAsString)).setter(MediaLiveInputRouterOutputConfiguration.setter(Builder::mediaLivePipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaLivePipelineId").build()}).build();
    private static final SdkField<MediaLiveTransitEncryption> DESTINATION_TRANSIT_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationTransitEncryption").getter(MediaLiveInputRouterOutputConfiguration.getter(MediaLiveInputRouterOutputConfiguration::destinationTransitEncryption)).setter(MediaLiveInputRouterOutputConfiguration.setter(Builder::destinationTransitEncryption)).constructor(MediaLiveTransitEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationTransitEncryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_LIVE_INPUT_ARN_FIELD, MEDIA_LIVE_PIPELINE_ID_FIELD, DESTINATION_TRANSIT_ENCRYPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaLiveInputRouterOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mediaLiveInputArn;
    private final String mediaLivePipelineId;
    private final MediaLiveTransitEncryption destinationTransitEncryption;

    private MediaLiveInputRouterOutputConfiguration(BuilderImpl builder) {
        this.mediaLiveInputArn = builder.mediaLiveInputArn;
        this.mediaLivePipelineId = builder.mediaLivePipelineId;
        this.destinationTransitEncryption = builder.destinationTransitEncryption;
    }

    public final String mediaLiveInputArn() {
        return this.mediaLiveInputArn;
    }

    public final MediaLiveInputPipelineId mediaLivePipelineId() {
        return MediaLiveInputPipelineId.fromValue(this.mediaLivePipelineId);
    }

    public final String mediaLivePipelineIdAsString() {
        return this.mediaLivePipelineId;
    }

    public final MediaLiveTransitEncryption destinationTransitEncryption() {
        return this.destinationTransitEncryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaLiveInputArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaLivePipelineIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTransitEncryption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaLiveInputRouterOutputConfiguration)) {
            return false;
        }
        MediaLiveInputRouterOutputConfiguration other = (MediaLiveInputRouterOutputConfiguration)obj;
        return Objects.equals(this.mediaLiveInputArn(), other.mediaLiveInputArn()) && Objects.equals(this.mediaLivePipelineIdAsString(), other.mediaLivePipelineIdAsString()) && Objects.equals(this.destinationTransitEncryption(), other.destinationTransitEncryption());
    }

    public final String toString() {
        return ToString.builder((String)"MediaLiveInputRouterOutputConfiguration").add("MediaLiveInputArn", (Object)this.mediaLiveInputArn()).add("MediaLivePipelineId", (Object)this.mediaLivePipelineIdAsString()).add("DestinationTransitEncryption", (Object)this.destinationTransitEncryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaLiveInputArn": {
                return Optional.ofNullable(clazz.cast(this.mediaLiveInputArn()));
            }
            case "MediaLivePipelineId": {
                return Optional.ofNullable(clazz.cast(this.mediaLivePipelineIdAsString()));
            }
            case "DestinationTransitEncryption": {
                return Optional.ofNullable(clazz.cast(this.destinationTransitEncryption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mediaLiveInputArn", MEDIA_LIVE_INPUT_ARN_FIELD);
        map.put("mediaLivePipelineId", MEDIA_LIVE_PIPELINE_ID_FIELD);
        map.put("destinationTransitEncryption", DESTINATION_TRANSIT_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaLiveInputRouterOutputConfiguration, T> g) {
        return obj -> g.apply((MediaLiveInputRouterOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaLiveInputArn;
        private String mediaLivePipelineId;
        private MediaLiveTransitEncryption destinationTransitEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaLiveInputRouterOutputConfiguration model) {
            this.mediaLiveInputArn(model.mediaLiveInputArn);
            this.mediaLivePipelineId(model.mediaLivePipelineId);
            this.destinationTransitEncryption(model.destinationTransitEncryption);
        }

        public final String getMediaLiveInputArn() {
            return this.mediaLiveInputArn;
        }

        public final void setMediaLiveInputArn(String mediaLiveInputArn) {
            this.mediaLiveInputArn = mediaLiveInputArn;
        }

        @Override
        public final Builder mediaLiveInputArn(String mediaLiveInputArn) {
            this.mediaLiveInputArn = mediaLiveInputArn;
            return this;
        }

        public final String getMediaLivePipelineId() {
            return this.mediaLivePipelineId;
        }

        public final void setMediaLivePipelineId(String mediaLivePipelineId) {
            this.mediaLivePipelineId = mediaLivePipelineId;
        }

        @Override
        public final Builder mediaLivePipelineId(String mediaLivePipelineId) {
            this.mediaLivePipelineId = mediaLivePipelineId;
            return this;
        }

        @Override
        public final Builder mediaLivePipelineId(MediaLiveInputPipelineId mediaLivePipelineId) {
            this.mediaLivePipelineId(mediaLivePipelineId == null ? null : mediaLivePipelineId.toString());
            return this;
        }

        public final MediaLiveTransitEncryption.Builder getDestinationTransitEncryption() {
            return this.destinationTransitEncryption != null ? this.destinationTransitEncryption.toBuilder() : null;
        }

        public final void setDestinationTransitEncryption(MediaLiveTransitEncryption.BuilderImpl destinationTransitEncryption) {
            this.destinationTransitEncryption = destinationTransitEncryption != null ? destinationTransitEncryption.build() : null;
        }

        @Override
        public final Builder destinationTransitEncryption(MediaLiveTransitEncryption destinationTransitEncryption) {
            this.destinationTransitEncryption = destinationTransitEncryption;
            return this;
        }

        public MediaLiveInputRouterOutputConfiguration build() {
            return new MediaLiveInputRouterOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaLiveInputRouterOutputConfiguration> {
        public Builder mediaLiveInputArn(String var1);

        public Builder mediaLivePipelineId(String var1);

        public Builder mediaLivePipelineId(MediaLiveInputPipelineId var1);

        public Builder destinationTransitEncryption(MediaLiveTransitEncryption var1);

        default public Builder destinationTransitEncryption(Consumer<MediaLiveTransitEncryption.Builder> destinationTransitEncryption) {
            return this.destinationTransitEncryption((MediaLiveTransitEncryption)((MediaLiveTransitEncryption.Builder)MediaLiveTransitEncryption.builder().applyMutation(destinationTransitEncryption)).build());
        }
    }
}

