/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.SrtEncryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SrtCallerRouterOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SrtCallerRouterOutputConfiguration> {
    private static final SdkField<String> DESTINATION_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationAddress").getter(SrtCallerRouterOutputConfiguration.getter(SrtCallerRouterOutputConfiguration::destinationAddress)).setter(SrtCallerRouterOutputConfiguration.setter(Builder::destinationAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAddress").build()}).build();
    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DestinationPort").getter(SrtCallerRouterOutputConfiguration.getter(SrtCallerRouterOutputConfiguration::destinationPort)).setter(SrtCallerRouterOutputConfiguration.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()}).build();
    private static final SdkField<Long> MINIMUM_LATENCY_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinimumLatencyMilliseconds").getter(SrtCallerRouterOutputConfiguration.getter(SrtCallerRouterOutputConfiguration::minimumLatencyMilliseconds)).setter(SrtCallerRouterOutputConfiguration.setter(Builder::minimumLatencyMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatencyMilliseconds").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(SrtCallerRouterOutputConfiguration.getter(SrtCallerRouterOutputConfiguration::streamId)).setter(SrtCallerRouterOutputConfiguration.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<SrtEncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(SrtCallerRouterOutputConfiguration.getter(SrtCallerRouterOutputConfiguration::encryptionConfiguration)).setter(SrtCallerRouterOutputConfiguration.setter(Builder::encryptionConfiguration)).constructor(SrtEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ADDRESS_FIELD, DESTINATION_PORT_FIELD, MINIMUM_LATENCY_MILLISECONDS_FIELD, STREAM_ID_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SrtCallerRouterOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationAddress;
    private final Integer destinationPort;
    private final Long minimumLatencyMilliseconds;
    private final String streamId;
    private final SrtEncryptionConfiguration encryptionConfiguration;

    private SrtCallerRouterOutputConfiguration(BuilderImpl builder) {
        this.destinationAddress = builder.destinationAddress;
        this.destinationPort = builder.destinationPort;
        this.minimumLatencyMilliseconds = builder.minimumLatencyMilliseconds;
        this.streamId = builder.streamId;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String destinationAddress() {
        return this.destinationAddress;
    }

    public final Integer destinationPort() {
        return this.destinationPort;
    }

    public final Long minimumLatencyMilliseconds() {
        return this.minimumLatencyMilliseconds;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final SrtEncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerRouterOutputConfiguration)) {
            return false;
        }
        SrtCallerRouterOutputConfiguration other = (SrtCallerRouterOutputConfiguration)obj;
        return Objects.equals(this.destinationAddress(), other.destinationAddress()) && Objects.equals(this.destinationPort(), other.destinationPort()) && Objects.equals(this.minimumLatencyMilliseconds(), other.minimumLatencyMilliseconds()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SrtCallerRouterOutputConfiguration").add("DestinationAddress", (Object)this.destinationAddress()).add("DestinationPort", (Object)this.destinationPort()).add("MinimumLatencyMilliseconds", (Object)this.minimumLatencyMilliseconds()).add("StreamId", (Object)this.streamId()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationAddress()));
            }
            case "DestinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "MinimumLatencyMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.minimumLatencyMilliseconds()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationAddress", DESTINATION_ADDRESS_FIELD);
        map.put("destinationPort", DESTINATION_PORT_FIELD);
        map.put("minimumLatencyMilliseconds", MINIMUM_LATENCY_MILLISECONDS_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerRouterOutputConfiguration, T> g) {
        return obj -> g.apply((SrtCallerRouterOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationAddress;
        private Integer destinationPort;
        private Long minimumLatencyMilliseconds;
        private String streamId;
        private SrtEncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerRouterOutputConfiguration model) {
            this.destinationAddress(model.destinationAddress);
            this.destinationPort(model.destinationPort);
            this.minimumLatencyMilliseconds(model.minimumLatencyMilliseconds);
            this.streamId(model.streamId);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getDestinationAddress() {
            return this.destinationAddress;
        }

        public final void setDestinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
        }

        @Override
        public final Builder destinationAddress(String destinationAddress) {
            this.destinationAddress = destinationAddress;
            return this;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final Long getMinimumLatencyMilliseconds() {
            return this.minimumLatencyMilliseconds;
        }

        public final void setMinimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
        }

        @Override
        public final Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final SrtEncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(SrtEncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(SrtEncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public SrtCallerRouterOutputConfiguration build() {
            return new SrtCallerRouterOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SrtCallerRouterOutputConfiguration> {
        public Builder destinationAddress(String var1);

        public Builder destinationPort(Integer var1);

        public Builder minimumLatencyMilliseconds(Long var1);

        public Builder streamId(String var1);

        public Builder encryptionConfiguration(SrtEncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<SrtEncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((SrtEncryptionConfiguration)((SrtEncryptionConfiguration.Builder)SrtEncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }
    }
}

