/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputProtocol;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputProtocolConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandardRouterInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandardRouterInputConfiguration> {
    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceArn").getter(StandardRouterInputConfiguration.getter(StandardRouterInputConfiguration::networkInterfaceArn)).setter(StandardRouterInputConfiguration.setter(Builder::networkInterfaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build()}).build();
    private static final SdkField<RouterInputProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtocolConfiguration").getter(StandardRouterInputConfiguration.getter(StandardRouterInputConfiguration::protocolConfiguration)).setter(StandardRouterInputConfiguration.setter(Builder::protocolConfiguration)).constructor(RouterInputProtocolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(StandardRouterInputConfiguration.getter(StandardRouterInputConfiguration::protocolAsString)).setter(StandardRouterInputConfiguration.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ARN_FIELD, PROTOCOL_CONFIGURATION_FIELD, PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StandardRouterInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkInterfaceArn;
    private final RouterInputProtocolConfiguration protocolConfiguration;
    private final String protocol;

    private StandardRouterInputConfiguration(BuilderImpl builder) {
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.protocol = builder.protocol;
    }

    public final String networkInterfaceArn() {
        return this.networkInterfaceArn;
    }

    public final RouterInputProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public final RouterInputProtocol protocol() {
        return RouterInputProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardRouterInputConfiguration)) {
            return false;
        }
        StandardRouterInputConfiguration other = (StandardRouterInputConfiguration)obj;
        return Objects.equals(this.networkInterfaceArn(), other.networkInterfaceArn()) && Objects.equals(this.protocolConfiguration(), other.protocolConfiguration()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StandardRouterInputConfiguration").add("NetworkInterfaceArn", (Object)this.networkInterfaceArn()).add("ProtocolConfiguration", (Object)this.protocolConfiguration()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceArn": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceArn()));
            }
            case "ProtocolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.protocolConfiguration()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardRouterInputConfiguration, T> g) {
        return obj -> g.apply((StandardRouterInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInterfaceArn;
        private RouterInputProtocolConfiguration protocolConfiguration;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardRouterInputConfiguration model) {
            this.networkInterfaceArn(model.networkInterfaceArn);
            this.protocolConfiguration(model.protocolConfiguration);
            this.protocol(model.protocol);
        }

        public final String getNetworkInterfaceArn() {
            return this.networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final RouterInputProtocolConfiguration.Builder getProtocolConfiguration() {
            return this.protocolConfiguration != null ? this.protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(RouterInputProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(RouterInputProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(RouterInputProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public StandardRouterInputConfiguration build() {
            return new StandardRouterInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandardRouterInputConfiguration> {
        public Builder networkInterfaceArn(String var1);

        public Builder protocolConfiguration(RouterInputProtocolConfiguration var1);

        default public Builder protocolConfiguration(Consumer<RouterInputProtocolConfiguration.Builder> protocolConfiguration) {
            return this.protocolConfiguration((RouterInputProtocolConfiguration)((RouterInputProtocolConfiguration.Builder)RouterInputProtocolConfiguration.builder().applyMutation(protocolConfiguration)).build());
        }

        public Builder protocol(String var1);

        public Builder protocol(RouterInputProtocol var1);
    }
}

