/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.AvailabilityZone;
import software.amazon.awssdk.services.memorydb.model.NetworkType;
import software.amazon.awssdk.services.memorydb.model.NetworkTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subnet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subnet> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(Subnet.getter(Subnet::identifier)).setter(Subnet.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<AvailabilityZone> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailabilityZone").getter(Subnet.getter(Subnet::availabilityZone)).setter(Subnet.setter(Builder::availabilityZone)).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_NETWORK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedNetworkTypes").getter(Subnet.getter(Subnet::supportedNetworkTypesAsStrings)).setter(Subnet.setter(Builder::supportedNetworkTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNetworkTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, AVAILABILITY_ZONE_FIELD, SUPPORTED_NETWORK_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Subnet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final AvailabilityZone availabilityZone;
    private final List<String> supportedNetworkTypes;

    private Subnet(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.availabilityZone = builder.availabilityZone;
        this.supportedNetworkTypes = builder.supportedNetworkTypes;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final AvailabilityZone availabilityZone() {
        return this.availabilityZone;
    }

    public final List<NetworkType> supportedNetworkTypes() {
        return NetworkTypeListCopier.copyStringToEnum(this.supportedNetworkTypes);
    }

    public final boolean hasSupportedNetworkTypes() {
        return this.supportedNetworkTypes != null && !(this.supportedNetworkTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedNetworkTypesAsStrings() {
        return this.supportedNetworkTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedNetworkTypes() ? this.supportedNetworkTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && this.hasSupportedNetworkTypes() == other.hasSupportedNetworkTypes() && Objects.equals(this.supportedNetworkTypesAsStrings(), other.supportedNetworkTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Subnet").add("Identifier", (Object)this.identifier()).add("AvailabilityZone", (Object)this.availabilityZone()).add("SupportedNetworkTypes", this.hasSupportedNetworkTypes() ? this.supportedNetworkTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "SupportedNetworkTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedNetworkTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("SupportedNetworkTypes", SUPPORTED_NETWORK_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subnet, T> g) {
        return obj -> g.apply((Subnet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private AvailabilityZone availabilityZone;
        private List<String> supportedNetworkTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.identifier(model.identifier);
            this.availabilityZone(model.availabilityZone);
            this.supportedNetworkTypesWithStrings(model.supportedNetworkTypes);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final AvailabilityZone.Builder getAvailabilityZone() {
            return this.availabilityZone != null ? this.availabilityZone.toBuilder() : null;
        }

        public final void setAvailabilityZone(AvailabilityZone.BuilderImpl availabilityZone) {
            this.availabilityZone = availabilityZone != null ? availabilityZone.build() : null;
        }

        @Override
        public final Builder availabilityZone(AvailabilityZone availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Collection<String> getSupportedNetworkTypes() {
            if (this.supportedNetworkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedNetworkTypes;
        }

        public final void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copy(supportedNetworkTypes);
        }

        @Override
        public final Builder supportedNetworkTypesWithStrings(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copy(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypesWithStrings(String ... supportedNetworkTypes) {
            this.supportedNetworkTypesWithStrings(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        @Override
        public final Builder supportedNetworkTypes(Collection<NetworkType> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copyEnumToString(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypes(NetworkType ... supportedNetworkTypes) {
            this.supportedNetworkTypes(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        public Subnet build() {
            return new Subnet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subnet> {
        public Builder identifier(String var1);

        public Builder availabilityZone(AvailabilityZone var1);

        default public Builder availabilityZone(Consumer<AvailabilityZone.Builder> availabilityZone) {
            return this.availabilityZone((AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation(availabilityZone)).build());
        }

        public Builder supportedNetworkTypesWithStrings(Collection<String> var1);

        public Builder supportedNetworkTypesWithStrings(String ... var1);

        public Builder supportedNetworkTypes(Collection<NetworkType> var1);

        public Builder supportedNetworkTypes(NetworkType ... var1);
    }
}

