/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkflowStepRequest
extends MigrationHubOrchestratorRequest
implements ToCopyableBuilder<Builder, CreateWorkflowStepRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::name)).setter(CreateWorkflowStepRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STEP_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepGroupId").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::stepGroupId)).setter(CreateWorkflowStepRequest.setter(Builder::stepGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepGroupId").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::workflowId)).setter(CreateWorkflowStepRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> STEP_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepActionType").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::stepActionTypeAsString)).setter(CreateWorkflowStepRequest.setter(Builder::stepActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepActionType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::description)).setter(CreateWorkflowStepRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<WorkflowStepAutomationConfiguration> WORKFLOW_STEP_AUTOMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflowStepAutomationConfiguration").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::workflowStepAutomationConfiguration)).setter(CreateWorkflowStepRequest.setter(Builder::workflowStepAutomationConfiguration)).constructor(WorkflowStepAutomationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowStepAutomationConfiguration").build()}).build();
    private static final SdkField<List<String>> STEP_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stepTarget").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::stepTarget)).setter(CreateWorkflowStepRequest.setter(Builder::stepTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTarget").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WorkflowStepOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputs").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::outputs)).setter(CreateWorkflowStepRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowStepOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("previous").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::previous)).setter(CreateWorkflowStepRequest.setter(Builder::previous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("next").getter(CreateWorkflowStepRequest.getter(CreateWorkflowStepRequest::next)).setter(CreateWorkflowStepRequest.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STEP_GROUP_ID_FIELD, WORKFLOW_ID_FIELD, STEP_ACTION_TYPE_FIELD, DESCRIPTION_FIELD, WORKFLOW_STEP_AUTOMATION_CONFIGURATION_FIELD, STEP_TARGET_FIELD, OUTPUTS_FIELD, PREVIOUS_FIELD, NEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkflowStepRequest.memberNameToFieldInitializer();
    private final String name;
    private final String stepGroupId;
    private final String workflowId;
    private final String stepActionType;
    private final String description;
    private final WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration;
    private final List<String> stepTarget;
    private final List<WorkflowStepOutput> outputs;
    private final List<String> previous;
    private final List<String> next;

    private CreateWorkflowStepRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.stepGroupId = builder.stepGroupId;
        this.workflowId = builder.workflowId;
        this.stepActionType = builder.stepActionType;
        this.description = builder.description;
        this.workflowStepAutomationConfiguration = builder.workflowStepAutomationConfiguration;
        this.stepTarget = builder.stepTarget;
        this.outputs = builder.outputs;
        this.previous = builder.previous;
        this.next = builder.next;
    }

    public final String name() {
        return this.name;
    }

    public final String stepGroupId() {
        return this.stepGroupId;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final StepActionType stepActionType() {
        return StepActionType.fromValue(this.stepActionType);
    }

    public final String stepActionTypeAsString() {
        return this.stepActionType;
    }

    public final String description() {
        return this.description;
    }

    public final WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration() {
        return this.workflowStepAutomationConfiguration;
    }

    public final boolean hasStepTarget() {
        return this.stepTarget != null && !(this.stepTarget instanceof SdkAutoConstructList);
    }

    public final List<String> stepTarget() {
        return this.stepTarget;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<WorkflowStepOutput> outputs() {
        return this.outputs;
    }

    public final boolean hasPrevious() {
        return this.previous != null && !(this.previous instanceof SdkAutoConstructList);
    }

    public final List<String> previous() {
        return this.previous;
    }

    public final boolean hasNext() {
        return this.next != null && !(this.next instanceof SdkAutoConstructList);
    }

    public final List<String> next() {
        return this.next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowStepAutomationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepTarget() ? this.stepTarget() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrevious() ? this.previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNext() ? this.next() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowStepRequest)) {
            return false;
        }
        CreateWorkflowStepRequest other = (CreateWorkflowStepRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stepGroupId(), other.stepGroupId()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.stepActionTypeAsString(), other.stepActionTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.workflowStepAutomationConfiguration(), other.workflowStepAutomationConfiguration()) && this.hasStepTarget() == other.hasStepTarget() && Objects.equals(this.stepTarget(), other.stepTarget()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && this.hasPrevious() == other.hasPrevious() && Objects.equals(this.previous(), other.previous()) && this.hasNext() == other.hasNext() && Objects.equals(this.next(), other.next());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkflowStepRequest").add("Name", (Object)this.name()).add("StepGroupId", (Object)this.stepGroupId()).add("WorkflowId", (Object)this.workflowId()).add("StepActionType", (Object)this.stepActionTypeAsString()).add("Description", (Object)this.description()).add("WorkflowStepAutomationConfiguration", (Object)this.workflowStepAutomationConfiguration()).add("StepTarget", this.hasStepTarget() ? this.stepTarget() : null).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("Previous", this.hasPrevious() ? this.previous() : null).add("Next", this.hasNext() ? this.next() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "stepGroupId": {
                return Optional.ofNullable(clazz.cast(this.stepGroupId()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "stepActionType": {
                return Optional.ofNullable(clazz.cast(this.stepActionTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "workflowStepAutomationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.workflowStepAutomationConfiguration()));
            }
            case "stepTarget": {
                return Optional.ofNullable(clazz.cast(this.stepTarget()));
            }
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "previous": {
                return Optional.ofNullable(clazz.cast(this.previous()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("stepGroupId", STEP_GROUP_ID_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("stepActionType", STEP_ACTION_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("workflowStepAutomationConfiguration", WORKFLOW_STEP_AUTOMATION_CONFIGURATION_FIELD);
        map.put("stepTarget", STEP_TARGET_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("previous", PREVIOUS_FIELD);
        map.put("next", NEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowStepRequest, T> g) {
        return obj -> g.apply((CreateWorkflowStepRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorRequest.BuilderImpl
    implements Builder {
        private String name;
        private String stepGroupId;
        private String workflowId;
        private String stepActionType;
        private String description;
        private WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration;
        private List<String> stepTarget = DefaultSdkAutoConstructList.getInstance();
        private List<WorkflowStepOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private List<String> previous = DefaultSdkAutoConstructList.getInstance();
        private List<String> next = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowStepRequest model) {
            super(model);
            this.name(model.name);
            this.stepGroupId(model.stepGroupId);
            this.workflowId(model.workflowId);
            this.stepActionType(model.stepActionType);
            this.description(model.description);
            this.workflowStepAutomationConfiguration(model.workflowStepAutomationConfiguration);
            this.stepTarget(model.stepTarget);
            this.outputs(model.outputs);
            this.previous(model.previous);
            this.next(model.next);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStepGroupId() {
            return this.stepGroupId;
        }

        public final void setStepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
        }

        @Override
        public final Builder stepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getStepActionType() {
            return this.stepActionType;
        }

        public final void setStepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
        }

        @Override
        public final Builder stepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
            return this;
        }

        @Override
        public final Builder stepActionType(StepActionType stepActionType) {
            this.stepActionType(stepActionType == null ? null : stepActionType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final WorkflowStepAutomationConfiguration.Builder getWorkflowStepAutomationConfiguration() {
            return this.workflowStepAutomationConfiguration != null ? this.workflowStepAutomationConfiguration.toBuilder() : null;
        }

        public final void setWorkflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration.BuilderImpl workflowStepAutomationConfiguration) {
            this.workflowStepAutomationConfiguration = workflowStepAutomationConfiguration != null ? workflowStepAutomationConfiguration.build() : null;
        }

        @Override
        public final Builder workflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration workflowStepAutomationConfiguration) {
            this.workflowStepAutomationConfiguration = workflowStepAutomationConfiguration;
            return this;
        }

        public final Collection<String> getStepTarget() {
            if (this.stepTarget instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stepTarget;
        }

        public final void setStepTarget(Collection<String> stepTarget) {
            this.stepTarget = StringListCopier.copy(stepTarget);
        }

        @Override
        public final Builder stepTarget(Collection<String> stepTarget) {
            this.stepTarget = StringListCopier.copy(stepTarget);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepTarget(String ... stepTarget) {
            this.stepTarget(Arrays.asList(stepTarget));
            return this;
        }

        public final List<WorkflowStepOutput.Builder> getOutputs() {
            List<WorkflowStepOutput.Builder> result = WorkflowStepOutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<WorkflowStepOutput.BuilderImpl> outputs) {
            this.outputs = WorkflowStepOutputListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<WorkflowStepOutput> outputs) {
            this.outputs = WorkflowStepOutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(WorkflowStepOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<WorkflowStepOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (WorkflowStepOutput)((WorkflowStepOutput.Builder)WorkflowStepOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPrevious() {
            if (this.previous instanceof SdkAutoConstructList) {
                return null;
            }
            return this.previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String ... previous) {
            this.previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (this.next instanceof SdkAutoConstructList) {
                return null;
            }
            return this.next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String ... next) {
            this.next(Arrays.asList(next));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowStepRequest build() {
            return new CreateWorkflowStepRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubOrchestratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkflowStepRequest> {
        public Builder name(String var1);

        public Builder stepGroupId(String var1);

        public Builder workflowId(String var1);

        public Builder stepActionType(String var1);

        public Builder stepActionType(StepActionType var1);

        public Builder description(String var1);

        public Builder workflowStepAutomationConfiguration(WorkflowStepAutomationConfiguration var1);

        default public Builder workflowStepAutomationConfiguration(Consumer<WorkflowStepAutomationConfiguration.Builder> workflowStepAutomationConfiguration) {
            return this.workflowStepAutomationConfiguration((WorkflowStepAutomationConfiguration)((WorkflowStepAutomationConfiguration.Builder)WorkflowStepAutomationConfiguration.builder().applyMutation(workflowStepAutomationConfiguration)).build());
        }

        public Builder stepTarget(Collection<String> var1);

        public Builder stepTarget(String ... var1);

        public Builder outputs(Collection<WorkflowStepOutput> var1);

        public Builder outputs(WorkflowStepOutput ... var1);

        public Builder outputs(Consumer<WorkflowStepOutput.Builder> ... var1);

        public Builder previous(Collection<String> var1);

        public Builder previous(String ... var1);

        public Builder next(Collection<String> var1);

        public Builder next(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

