/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationHubOrchestratorResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepAutomationConfiguration;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutput;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StepOutputListCopier;
import software.amazon.awssdk.services.migrationhuborchestrator.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateStepResponse
extends MigrationHubOrchestratorResponse
implements ToCopyableBuilder<Builder, GetTemplateStepResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::id)).setter(GetTemplateStepResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STEP_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepGroupId").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::stepGroupId)).setter(GetTemplateStepResponse.setter(Builder::stepGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepGroupId").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::templateId)).setter(GetTemplateStepResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::name)).setter(GetTemplateStepResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::description)).setter(GetTemplateStepResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STEP_ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepActionType").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::stepActionTypeAsString)).setter(GetTemplateStepResponse.setter(Builder::stepActionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepActionType").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationTime").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::creationTime)).setter(GetTemplateStepResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<List<String>> PREVIOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("previous").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::previous)).setter(GetTemplateStepResponse.setter(Builder::previous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previous").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("next").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::next)).setter(GetTemplateStepResponse.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StepOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputs").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::outputs)).setter(GetTemplateStepResponse.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StepAutomationConfiguration> STEP_AUTOMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stepAutomationConfiguration").getter(GetTemplateStepResponse.getter(GetTemplateStepResponse::stepAutomationConfiguration)).setter(GetTemplateStepResponse.setter(Builder::stepAutomationConfiguration)).constructor(StepAutomationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepAutomationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STEP_GROUP_ID_FIELD, TEMPLATE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STEP_ACTION_TYPE_FIELD, CREATION_TIME_FIELD, PREVIOUS_FIELD, NEXT_FIELD, OUTPUTS_FIELD, STEP_AUTOMATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTemplateStepResponse.memberNameToFieldInitializer();
    private final String id;
    private final String stepGroupId;
    private final String templateId;
    private final String name;
    private final String description;
    private final String stepActionType;
    private final String creationTime;
    private final List<String> previous;
    private final List<String> next;
    private final List<StepOutput> outputs;
    private final StepAutomationConfiguration stepAutomationConfiguration;

    private GetTemplateStepResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.stepGroupId = builder.stepGroupId;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.description = builder.description;
        this.stepActionType = builder.stepActionType;
        this.creationTime = builder.creationTime;
        this.previous = builder.previous;
        this.next = builder.next;
        this.outputs = builder.outputs;
        this.stepAutomationConfiguration = builder.stepAutomationConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String stepGroupId() {
        return this.stepGroupId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final StepActionType stepActionType() {
        return StepActionType.fromValue(this.stepActionType);
    }

    public final String stepActionTypeAsString() {
        return this.stepActionType;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final boolean hasPrevious() {
        return this.previous != null && !(this.previous instanceof SdkAutoConstructList);
    }

    public final List<String> previous() {
        return this.previous;
    }

    public final boolean hasNext() {
        return this.next != null && !(this.next instanceof SdkAutoConstructList);
    }

    public final List<String> next() {
        return this.next;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<StepOutput> outputs() {
        return this.outputs;
    }

    public final StepAutomationConfiguration stepAutomationConfiguration() {
        return this.stepAutomationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrevious() ? this.previous() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNext() ? this.next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stepAutomationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateStepResponse)) {
            return false;
        }
        GetTemplateStepResponse other = (GetTemplateStepResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.stepGroupId(), other.stepGroupId()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stepActionTypeAsString(), other.stepActionTypeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && this.hasPrevious() == other.hasPrevious() && Objects.equals(this.previous(), other.previous()) && this.hasNext() == other.hasNext() && Objects.equals(this.next(), other.next()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.stepAutomationConfiguration(), other.stepAutomationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetTemplateStepResponse").add("Id", (Object)this.id()).add("StepGroupId", (Object)this.stepGroupId()).add("TemplateId", (Object)this.templateId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("StepActionType", (Object)this.stepActionTypeAsString()).add("CreationTime", (Object)this.creationTime()).add("Previous", this.hasPrevious() ? this.previous() : null).add("Next", this.hasNext() ? this.next() : null).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("StepAutomationConfiguration", (Object)this.stepAutomationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "stepGroupId": {
                return Optional.ofNullable(clazz.cast(this.stepGroupId()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "stepActionType": {
                return Optional.ofNullable(clazz.cast(this.stepActionTypeAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "previous": {
                return Optional.ofNullable(clazz.cast(this.previous()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "stepAutomationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stepAutomationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("stepGroupId", STEP_GROUP_ID_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("stepActionType", STEP_ACTION_TYPE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("previous", PREVIOUS_FIELD);
        map.put("next", NEXT_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        map.put("stepAutomationConfiguration", STEP_AUTOMATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateStepResponse, T> g) {
        return obj -> g.apply((GetTemplateStepResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubOrchestratorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String stepGroupId;
        private String templateId;
        private String name;
        private String description;
        private String stepActionType;
        private String creationTime;
        private List<String> previous = DefaultSdkAutoConstructList.getInstance();
        private List<String> next = DefaultSdkAutoConstructList.getInstance();
        private List<StepOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private StepAutomationConfiguration stepAutomationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateStepResponse model) {
            super(model);
            this.id(model.id);
            this.stepGroupId(model.stepGroupId);
            this.templateId(model.templateId);
            this.name(model.name);
            this.description(model.description);
            this.stepActionType(model.stepActionType);
            this.creationTime(model.creationTime);
            this.previous(model.previous);
            this.next(model.next);
            this.outputs(model.outputs);
            this.stepAutomationConfiguration(model.stepAutomationConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStepGroupId() {
            return this.stepGroupId;
        }

        public final void setStepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
        }

        @Override
        public final Builder stepGroupId(String stepGroupId) {
            this.stepGroupId = stepGroupId;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStepActionType() {
            return this.stepActionType;
        }

        public final void setStepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
        }

        @Override
        public final Builder stepActionType(String stepActionType) {
            this.stepActionType = stepActionType;
            return this;
        }

        @Override
        public final Builder stepActionType(StepActionType stepActionType) {
            this.stepActionType(stepActionType == null ? null : stepActionType.toString());
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Collection<String> getPrevious() {
            if (this.previous instanceof SdkAutoConstructList) {
                return null;
            }
            return this.previous;
        }

        public final void setPrevious(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
        }

        @Override
        public final Builder previous(Collection<String> previous) {
            this.previous = StringListCopier.copy(previous);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previous(String ... previous) {
            this.previous(Arrays.asList(previous));
            return this;
        }

        public final Collection<String> getNext() {
            if (this.next instanceof SdkAutoConstructList) {
                return null;
            }
            return this.next;
        }

        public final void setNext(Collection<String> next) {
            this.next = StringListCopier.copy(next);
        }

        @Override
        public final Builder next(Collection<String> next) {
            this.next = StringListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(String ... next) {
            this.next(Arrays.asList(next));
            return this;
        }

        public final List<StepOutput.Builder> getOutputs() {
            List<StepOutput.Builder> result = StepOutputListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<StepOutput.BuilderImpl> outputs) {
            this.outputs = StepOutputListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<StepOutput> outputs) {
            this.outputs = StepOutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(StepOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<StepOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (StepOutput)((StepOutput.Builder)StepOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StepAutomationConfiguration.Builder getStepAutomationConfiguration() {
            return this.stepAutomationConfiguration != null ? this.stepAutomationConfiguration.toBuilder() : null;
        }

        public final void setStepAutomationConfiguration(StepAutomationConfiguration.BuilderImpl stepAutomationConfiguration) {
            this.stepAutomationConfiguration = stepAutomationConfiguration != null ? stepAutomationConfiguration.build() : null;
        }

        @Override
        public final Builder stepAutomationConfiguration(StepAutomationConfiguration stepAutomationConfiguration) {
            this.stepAutomationConfiguration = stepAutomationConfiguration;
            return this;
        }

        @Override
        public GetTemplateStepResponse build() {
            return new GetTemplateStepResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MigrationHubOrchestratorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateStepResponse> {
        public Builder id(String var1);

        public Builder stepGroupId(String var1);

        public Builder templateId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder stepActionType(String var1);

        public Builder stepActionType(StepActionType var1);

        public Builder creationTime(String var1);

        public Builder previous(Collection<String> var1);

        public Builder previous(String ... var1);

        public Builder next(Collection<String> var1);

        public Builder next(String ... var1);

        public Builder outputs(Collection<StepOutput> var1);

        public Builder outputs(StepOutput ... var1);

        public Builder outputs(Consumer<StepOutput.Builder> ... var1);

        public Builder stepAutomationConfiguration(StepAutomationConfiguration var1);

        default public Builder stepAutomationConfiguration(Consumer<StepAutomationConfiguration.Builder> stepAutomationConfiguration) {
            return this.stepAutomationConfiguration((StepAutomationConfiguration)((StepAutomationConfiguration.Builder)StepAutomationConfiguration.builder().applyMutation(stepAutomationConfiguration)).build());
        }
    }
}

