/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.migrationhuborchestrator.model.DataType;
import software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutputUnion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowStepOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowStepOutput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(WorkflowStepOutput.getter(WorkflowStepOutput::name)).setter(WorkflowStepOutput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(WorkflowStepOutput.getter(WorkflowStepOutput::dataTypeAsString)).setter(WorkflowStepOutput.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("required").getter(WorkflowStepOutput.getter(WorkflowStepOutput::required)).setter(WorkflowStepOutput.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()}).build();
    private static final SdkField<WorkflowStepOutputUnion> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(WorkflowStepOutput.getter(WorkflowStepOutput::value)).setter(WorkflowStepOutput.setter(Builder::value)).constructor(WorkflowStepOutputUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_TYPE_FIELD, REQUIRED_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkflowStepOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String dataType;
    private final Boolean required;
    private final WorkflowStepOutputUnion value;

    private WorkflowStepOutput(BuilderImpl builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.required = builder.required;
        this.value = builder.value;
    }

    public final String name() {
        return this.name;
    }

    public final DataType dataType() {
        return DataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final Boolean required() {
        return this.required;
    }

    public final WorkflowStepOutputUnion value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepOutput)) {
            return false;
        }
        WorkflowStepOutput other = (WorkflowStepOutput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowStepOutput").add("Name", (Object)this.name()).add("DataType", (Object)this.dataTypeAsString()).add("Required", (Object)this.required()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("required", REQUIRED_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepOutput, T> g) {
        return obj -> g.apply((WorkflowStepOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String dataType;
        private Boolean required;
        private WorkflowStepOutputUnion value;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepOutput model) {
            this.name(model.name);
            this.dataType(model.dataType);
            this.required(model.required);
            this.value(model.value);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(DataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final WorkflowStepOutputUnion.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(WorkflowStepOutputUnion.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(WorkflowStepOutputUnion value) {
            this.value = value;
            return this;
        }

        public WorkflowStepOutput build() {
            return new WorkflowStepOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowStepOutput> {
        public Builder name(String var1);

        public Builder dataType(String var1);

        public Builder dataType(DataType var1);

        public Builder required(Boolean var1);

        public Builder value(WorkflowStepOutputUnion var1);

        default public Builder value(Consumer<WorkflowStepOutputUnion.Builder> value) {
            return this.value((WorkflowStepOutputUnion)((WorkflowStepOutputUnion.Builder)WorkflowStepOutputUnion.builder().applyMutation(value)).build());
        }
    }
}

