/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhuborchestrator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorClient;
import software.amazon.awssdk.services.migrationhuborchestrator.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsRequest;
import software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse;
import software.amazon.awssdk.services.migrationhuborchestrator.model.PluginSummary;

public class ListPluginsIterable
implements SdkIterable<ListPluginsResponse> {
    private final MigrationHubOrchestratorClient client;
    private final ListPluginsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPluginsIterable(MigrationHubOrchestratorClient client, ListPluginsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPluginsResponseFetcher();
    }

    public Iterator<ListPluginsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PluginSummary> plugins() {
        Function<ListPluginsResponse, Iterator> getIterator = response -> {
            if (response != null && response.plugins() != null) {
                return response.plugins().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPluginsResponseFetcher
    implements SyncPageFetcher<ListPluginsResponse> {
        private ListPluginsResponseFetcher() {
        }

        public boolean hasNextPage(ListPluginsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPluginsResponse nextPage(ListPluginsResponse previousPage) {
            if (previousPage == null) {
                return ListPluginsIterable.this.client.listPlugins(ListPluginsIterable.this.firstRequest);
            }
            return ListPluginsIterable.this.client.listPlugins((ListPluginsRequest)((Object)ListPluginsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

