/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationChildEventsResponse;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationChildEventOverview;

public class ListManagedNotificationChildEventsIterable
implements SdkIterable<ListManagedNotificationChildEventsResponse> {
    private final NotificationsClient client;
    private final ListManagedNotificationChildEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedNotificationChildEventsIterable(NotificationsClient client, ListManagedNotificationChildEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedNotificationChildEventsResponseFetcher();
    }

    public Iterator<ListManagedNotificationChildEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedNotificationChildEventOverview> managedNotificationChildEvents() {
        Function<ListManagedNotificationChildEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedNotificationChildEvents() != null) {
                return response.managedNotificationChildEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedNotificationChildEventsResponseFetcher
    implements SyncPageFetcher<ListManagedNotificationChildEventsResponse> {
        private ListManagedNotificationChildEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedNotificationChildEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedNotificationChildEventsResponse nextPage(ListManagedNotificationChildEventsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedNotificationChildEventsIterable.this.client.listManagedNotificationChildEvents(ListManagedNotificationChildEventsIterable.this.firstRequest);
            }
            return ListManagedNotificationChildEventsIterable.this.client.listManagedNotificationChildEvents((ListManagedNotificationChildEventsRequest)((Object)ListManagedNotificationChildEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

