/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsAsyncClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationConfigurationsResponse;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationConfigurationStructure;

public class ListManagedNotificationConfigurationsPublisher
implements SdkPublisher<ListManagedNotificationConfigurationsResponse> {
    private final NotificationsAsyncClient client;
    private final ListManagedNotificationConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedNotificationConfigurationsPublisher(NotificationsAsyncClient client, ListManagedNotificationConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedNotificationConfigurationsPublisher(NotificationsAsyncClient client, ListManagedNotificationConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedNotificationConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedNotificationConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedNotificationConfigurationStructure> managedNotificationConfigurations() {
        Function<ListManagedNotificationConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedNotificationConfigurations() != null) {
                return response.managedNotificationConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedNotificationConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedNotificationConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListManagedNotificationConfigurationsResponse> {
        private ListManagedNotificationConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedNotificationConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedNotificationConfigurationsResponse> nextPage(ListManagedNotificationConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedNotificationConfigurationsPublisher.this.client.listManagedNotificationConfigurations(ListManagedNotificationConfigurationsPublisher.this.firstRequest);
            }
            return ListManagedNotificationConfigurationsPublisher.this.client.listManagedNotificationConfigurations((ListManagedNotificationConfigurationsRequest)((Object)ListManagedNotificationConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

