/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationEventOverview;

public class ListManagedNotificationEventsIterable
implements SdkIterable<ListManagedNotificationEventsResponse> {
    private final NotificationsClient client;
    private final ListManagedNotificationEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedNotificationEventsIterable(NotificationsClient client, ListManagedNotificationEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedNotificationEventsResponseFetcher();
    }

    public Iterator<ListManagedNotificationEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedNotificationEventOverview> managedNotificationEvents() {
        Function<ListManagedNotificationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedNotificationEvents() != null) {
                return response.managedNotificationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedNotificationEventsResponseFetcher
    implements SyncPageFetcher<ListManagedNotificationEventsResponse> {
        private ListManagedNotificationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedNotificationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedNotificationEventsResponse nextPage(ListManagedNotificationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedNotificationEventsIterable.this.client.listManagedNotificationEvents(ListManagedNotificationEventsIterable.this.firstRequest);
            }
            return ListManagedNotificationEventsIterable.this.client.listManagedNotificationEvents((ListManagedNotificationEventsRequest)((Object)ListManagedNotificationEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

