/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsAsyncClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListManagedNotificationEventsResponse;
import software.amazon.awssdk.services.notifications.model.ManagedNotificationEventOverview;

public class ListManagedNotificationEventsPublisher
implements SdkPublisher<ListManagedNotificationEventsResponse> {
    private final NotificationsAsyncClient client;
    private final ListManagedNotificationEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedNotificationEventsPublisher(NotificationsAsyncClient client, ListManagedNotificationEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedNotificationEventsPublisher(NotificationsAsyncClient client, ListManagedNotificationEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedNotificationEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedNotificationEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedNotificationEventOverview> managedNotificationEvents() {
        Function<ListManagedNotificationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedNotificationEvents() != null) {
                return response.managedNotificationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedNotificationEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedNotificationEventsResponseFetcher
    implements AsyncPageFetcher<ListManagedNotificationEventsResponse> {
        private ListManagedNotificationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedNotificationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedNotificationEventsResponse> nextPage(ListManagedNotificationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedNotificationEventsPublisher.this.client.listManagedNotificationEvents(ListManagedNotificationEventsPublisher.this.firstRequest);
            }
            return ListManagedNotificationEventsPublisher.this.client.listManagedNotificationEvents((ListManagedNotificationEventsRequest)((Object)ListManagedNotificationEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

