/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.notifications.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.notifications.NotificationsClient;
import software.amazon.awssdk.services.notifications.internal.UserAgentUtils;
import software.amazon.awssdk.services.notifications.model.ListNotificationEventsRequest;
import software.amazon.awssdk.services.notifications.model.ListNotificationEventsResponse;
import software.amazon.awssdk.services.notifications.model.NotificationEventOverview;

public class ListNotificationEventsIterable
implements SdkIterable<ListNotificationEventsResponse> {
    private final NotificationsClient client;
    private final ListNotificationEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNotificationEventsIterable(NotificationsClient client, ListNotificationEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListNotificationEventsResponseFetcher();
    }

    public Iterator<ListNotificationEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NotificationEventOverview> notificationEvents() {
        Function<ListNotificationEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.notificationEvents() != null) {
                return response.notificationEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListNotificationEventsResponseFetcher
    implements SyncPageFetcher<ListNotificationEventsResponse> {
        private ListNotificationEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNotificationEventsResponse nextPage(ListNotificationEventsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationEventsIterable.this.client.listNotificationEvents(ListNotificationEventsIterable.this.firstRequest);
            }
            return ListNotificationEventsIterable.this.client.listNotificationEvents((ListNotificationEventsRequest)((Object)ListNotificationEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

