/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ImportReadSetFilter;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReadSetImportJobsRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, ListReadSetImportJobsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListReadSetImportJobsRequest.getter(ListReadSetImportJobsRequest::maxResults)).setter(ListReadSetImportJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReadSetImportJobsRequest.getter(ListReadSetImportJobsRequest::nextToken)).setter(ListReadSetImportJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(ListReadSetImportJobsRequest.getter(ListReadSetImportJobsRequest::sequenceStoreId)).setter(ListReadSetImportJobsRequest.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<ImportReadSetFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(ListReadSetImportJobsRequest.getter(ListReadSetImportJobsRequest::filter)).setter(ListReadSetImportJobsRequest.setter(Builder::filter)).constructor(ImportReadSetFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEQUENCE_STORE_ID_FIELD, FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReadSetImportJobsRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final String sequenceStoreId;
    private final ImportReadSetFilter filter;

    private ListReadSetImportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sequenceStoreId = builder.sequenceStoreId;
        this.filter = builder.filter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final ImportReadSetFilter filter() {
        return this.filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetImportJobsRequest)) {
            return false;
        }
        ListReadSetImportJobsRequest other = (ListReadSetImportJobsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"ListReadSetImportJobsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SequenceStoreId", (Object)this.sequenceStoreId()).add("Filter", (Object)this.filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetImportJobsRequest, T> g) {
        return obj -> g.apply((ListReadSetImportJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String sequenceStoreId;
        private ImportReadSetFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetImportJobsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sequenceStoreId(model.sequenceStoreId);
            this.filter(model.filter);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final ImportReadSetFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(ImportReadSetFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ImportReadSetFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReadSetImportJobsRequest build() {
            return new ListReadSetImportJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReadSetImportJobsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sequenceStoreId(String var1);

        public Builder filter(ImportReadSetFilter var1);

        default public Builder filter(Consumer<ImportReadSetFilter.Builder> filter) {
            return this.filter((ImportReadSetFilter)((ImportReadSetFilter.Builder)ImportReadSetFilter.builder().applyMutation(filter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

