/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkflowStatus {
    CREATING("CREATING"),
    ACTIVE("ACTIVE"),
    UPDATING("UPDATING"),
    DELETED("DELETED"),
    FAILED("FAILED"),
    INACTIVE("INACTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkflowStatus> VALUE_MAP;
    private final String value;

    private WorkflowStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowStatus> knownValues() {
        EnumSet<WorkflowStatus> knownValues = EnumSet.allOf(WorkflowStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkflowStatus.class, WorkflowStatus::toString);
    }
}

