/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListRunCachesRequest;
import software.amazon.awssdk.services.omics.model.ListRunCachesResponse;
import software.amazon.awssdk.services.omics.model.RunCacheListItem;

public class ListRunCachesPublisher
implements SdkPublisher<ListRunCachesResponse> {
    private final OmicsAsyncClient client;
    private final ListRunCachesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRunCachesPublisher(OmicsAsyncClient client, ListRunCachesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRunCachesPublisher(OmicsAsyncClient client, ListRunCachesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRunCachesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRunCachesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RunCacheListItem> items() {
        Function<ListRunCachesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRunCachesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRunCachesResponseFetcher
    implements AsyncPageFetcher<ListRunCachesResponse> {
        private ListRunCachesResponseFetcher() {
        }

        public boolean hasNextPage(ListRunCachesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRunCachesResponse> nextPage(ListRunCachesResponse previousPage) {
            if (previousPage == null) {
                return ListRunCachesPublisher.this.client.listRunCaches(ListRunCachesPublisher.this.firstRequest);
            }
            return ListRunCachesPublisher.this.client.listRunCaches((ListRunCachesRequest)((Object)ListRunCachesPublisher.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

