/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListRunGroupsRequest;
import software.amazon.awssdk.services.omics.model.ListRunGroupsResponse;
import software.amazon.awssdk.services.omics.model.RunGroupListItem;

public class ListRunGroupsPublisher
implements SdkPublisher<ListRunGroupsResponse> {
    private final OmicsAsyncClient client;
    private final ListRunGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRunGroupsPublisher(OmicsAsyncClient client, ListRunGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRunGroupsPublisher(OmicsAsyncClient client, ListRunGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRunGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRunGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RunGroupListItem> items() {
        Function<ListRunGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRunGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRunGroupsResponseFetcher
    implements AsyncPageFetcher<ListRunGroupsResponse> {
        private ListRunGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListRunGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRunGroupsResponse> nextPage(ListRunGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListRunGroupsPublisher.this.client.listRunGroups(ListRunGroupsPublisher.this.firstRequest);
            }
            return ListRunGroupsPublisher.this.client.listRunGroups((ListRunGroupsRequest)((Object)ListRunGroupsPublisher.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

