/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pcaconnectorad.model.PcaConnectorAdRequest;
import software.amazon.awssdk.services.pcaconnectorad.model.TemplateDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTemplateRequest
extends PcaConnectorAdRequest
implements ToCopyableBuilder<Builder, UpdateTemplateRequest> {
    private static final SdkField<TemplateDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::definition)).setter(UpdateTemplateRequest.setter(Builder::definition)).constructor(TemplateDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<Boolean> REENROLL_ALL_CERTIFICATE_HOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReenrollAllCertificateHolders").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::reenrollAllCertificateHolders)).setter(UpdateTemplateRequest.setter(Builder::reenrollAllCertificateHolders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReenrollAllCertificateHolders").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(UpdateTemplateRequest.getter(UpdateTemplateRequest::templateArn)).setter(UpdateTemplateRequest.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, REENROLL_ALL_CERTIFICATE_HOLDERS_FIELD, TEMPLATE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTemplateRequest.memberNameToFieldInitializer();
    private final TemplateDefinition definition;
    private final Boolean reenrollAllCertificateHolders;
    private final String templateArn;

    private UpdateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.reenrollAllCertificateHolders = builder.reenrollAllCertificateHolders;
        this.templateArn = builder.templateArn;
    }

    public final TemplateDefinition definition() {
        return this.definition;
    }

    public final Boolean reenrollAllCertificateHolders() {
        return this.reenrollAllCertificateHolders;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.reenrollAllCertificateHolders());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTemplateRequest)) {
            return false;
        }
        UpdateTemplateRequest other = (UpdateTemplateRequest)((Object)obj);
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.reenrollAllCertificateHolders(), other.reenrollAllCertificateHolders()) && Objects.equals(this.templateArn(), other.templateArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTemplateRequest").add("Definition", (Object)this.definition()).add("ReenrollAllCertificateHolders", (Object)this.reenrollAllCertificateHolders()).add("TemplateArn", (Object)this.templateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "ReenrollAllCertificateHolders": {
                return Optional.ofNullable(clazz.cast(this.reenrollAllCertificateHolders()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Definition", DEFINITION_FIELD);
        map.put("ReenrollAllCertificateHolders", REENROLL_ALL_CERTIFICATE_HOLDERS_FIELD);
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTemplateRequest, T> g) {
        return obj -> g.apply((UpdateTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PcaConnectorAdRequest.BuilderImpl
    implements Builder {
        private TemplateDefinition definition;
        private Boolean reenrollAllCertificateHolders;
        private String templateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTemplateRequest model) {
            super(model);
            this.definition(model.definition);
            this.reenrollAllCertificateHolders(model.reenrollAllCertificateHolders);
            this.templateArn(model.templateArn);
        }

        public final TemplateDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(TemplateDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(TemplateDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Boolean getReenrollAllCertificateHolders() {
            return this.reenrollAllCertificateHolders;
        }

        public final void setReenrollAllCertificateHolders(Boolean reenrollAllCertificateHolders) {
            this.reenrollAllCertificateHolders = reenrollAllCertificateHolders;
        }

        @Override
        public final Builder reenrollAllCertificateHolders(Boolean reenrollAllCertificateHolders) {
            this.reenrollAllCertificateHolders = reenrollAllCertificateHolders;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTemplateRequest build() {
            return new UpdateTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PcaConnectorAdRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTemplateRequest> {
        public Builder definition(TemplateDefinition var1);

        default public Builder definition(Consumer<TemplateDefinition.Builder> definition) {
            return this.definition((TemplateDefinition)((TemplateDefinition.Builder)TemplateDefinition.builder().applyMutation(definition)).build());
        }

        public Builder reenrollAllCertificateHolders(Boolean var1);

        public Builder templateArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

