/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterIdentifierListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityCenterAuthTokenRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, GetIdentityCenterAuthTokenRequest> {
    private static final SdkField<List<String>> CLUSTER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterIds").getter(GetIdentityCenterAuthTokenRequest.getter(GetIdentityCenterAuthTokenRequest::clusterIds)).setter(GetIdentityCenterAuthTokenRequest.setter(Builder::clusterIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIds").build(), ListTrait.builder().memberLocationName("ClusterIdentifier").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIdentityCenterAuthTokenRequest.memberNameToFieldInitializer();
    private final List<String> clusterIds;

    private GetIdentityCenterAuthTokenRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIds = builder.clusterIds;
    }

    public final boolean hasClusterIds() {
        return this.clusterIds != null && !(this.clusterIds instanceof SdkAutoConstructList);
    }

    public final List<String> clusterIds() {
        return this.clusterIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterIds() ? this.clusterIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityCenterAuthTokenRequest)) {
            return false;
        }
        GetIdentityCenterAuthTokenRequest other = (GetIdentityCenterAuthTokenRequest)((Object)obj);
        return this.hasClusterIds() == other.hasClusterIds() && Objects.equals(this.clusterIds(), other.clusterIds());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityCenterAuthTokenRequest").add("ClusterIds", this.hasClusterIds() ? this.clusterIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIds": {
                return Optional.ofNullable(clazz.cast(this.clusterIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ClusterIds", CLUSTER_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityCenterAuthTokenRequest, T> g) {
        return obj -> g.apply((GetIdentityCenterAuthTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private List<String> clusterIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityCenterAuthTokenRequest model) {
            super(model);
            this.clusterIds(model.clusterIds);
        }

        public final Collection<String> getClusterIds() {
            if (this.clusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusterIds;
        }

        public final void setClusterIds(Collection<String> clusterIds) {
            this.clusterIds = ClusterIdentifierListCopier.copy(clusterIds);
        }

        @Override
        public final Builder clusterIds(Collection<String> clusterIds) {
            this.clusterIds = ClusterIdentifierListCopier.copy(clusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterIds(String ... clusterIds) {
            this.clusterIds(Arrays.asList(clusterIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdentityCenterAuthTokenRequest build() {
            return new GetIdentityCenterAuthTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityCenterAuthTokenRequest> {
        public Builder clusterIds(Collection<String> var1);

        public Builder clusterIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

