/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse;
import software.amazon.awssdk.services.redshift.model.EndpointAuthorization;

public class DescribeEndpointAuthorizationIterable
implements SdkIterable<DescribeEndpointAuthorizationResponse> {
    private final RedshiftClient client;
    private final DescribeEndpointAuthorizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEndpointAuthorizationIterable(RedshiftClient client, DescribeEndpointAuthorizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeEndpointAuthorizationResponseFetcher();
    }

    public Iterator<DescribeEndpointAuthorizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EndpointAuthorization> endpointAuthorizationList() {
        Function<DescribeEndpointAuthorizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpointAuthorizationList() != null) {
                return response.endpointAuthorizationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeEndpointAuthorizationResponseFetcher
    implements SyncPageFetcher<DescribeEndpointAuthorizationResponse> {
        private DescribeEndpointAuthorizationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointAuthorizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeEndpointAuthorizationResponse nextPage(DescribeEndpointAuthorizationResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointAuthorizationIterable.this.client.describeEndpointAuthorization(DescribeEndpointAuthorizationIterable.this.firstRequest);
            }
            return DescribeEndpointAuthorizationIterable.this.client.describeEndpointAuthorization((DescribeEndpointAuthorizationRequest)((Object)DescribeEndpointAuthorizationIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

