/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.redshift.model.ScheduledAction;

public class DescribeScheduledActionsPublisher
implements SdkPublisher<DescribeScheduledActionsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeScheduledActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeScheduledActionsPublisher(RedshiftAsyncClient client, DescribeScheduledActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeScheduledActionsPublisher(RedshiftAsyncClient client, DescribeScheduledActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScheduledActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScheduledActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledAction> scheduledActions() {
        Function<DescribeScheduledActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledActions() != null) {
                return response.scheduledActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeScheduledActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeScheduledActionsResponseFetcher
    implements AsyncPageFetcher<DescribeScheduledActionsResponse> {
        private DescribeScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeScheduledActionsResponse> nextPage(DescribeScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledActionsPublisher.this.client.describeScheduledActions(DescribeScheduledActionsPublisher.this.firstRequest);
            }
            return DescribeScheduledActionsPublisher.this.client.describeScheduledActions((DescribeScheduledActionsRequest)((Object)DescribeScheduledActionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

