/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CRResourceStatus {
    CREATING("CREATING"),
    OPERATIONAL("OPERATIONAL"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CRResourceStatus> VALUE_MAP;
    private final String value;

    private CRResourceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CRResourceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CRResourceStatus> knownValues() {
        EnumSet<CRResourceStatus> knownValues = EnumSet.allOf(CRResourceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CRResourceStatus.class, CRResourceStatus::toString);
    }
}

