/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.TokenStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessTokenResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, CreateAccessTokenResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::id)).setter(CreateAccessTokenResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::arn)).setter(CreateAccessTokenResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::clientToken)).setter(CreateAccessTokenResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::createdAt)).setter(CreateAccessTokenResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsViewId").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::dnsViewId)).setter(CreateAccessTokenResponse.setter(Builder::dnsViewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViewId").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::expiresAt)).setter(CreateAccessTokenResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::name)).setter(CreateAccessTokenResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::statusAsString)).setter(CreateAccessTokenResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::value)).setter(CreateAccessTokenResponse.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, CLIENT_TOKEN_FIELD, CREATED_AT_FIELD, DNS_VIEW_ID_FIELD, EXPIRES_AT_FIELD, NAME_FIELD, STATUS_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccessTokenResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String clientToken;
    private final Instant createdAt;
    private final String dnsViewId;
    private final Instant expiresAt;
    private final String name;
    private final String status;
    private final String value;

    private CreateAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.createdAt = builder.createdAt;
        this.dnsViewId = builder.dnsViewId;
        this.expiresAt = builder.expiresAt;
        this.name = builder.name;
        this.status = builder.status;
        this.value = builder.value;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String dnsViewId() {
        return this.dnsViewId;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final String name() {
        return this.name;
    }

    public final TokenStatus status() {
        return TokenStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessTokenResponse)) {
            return false;
        }
        CreateAccessTokenResponse other = (CreateAccessTokenResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dnsViewId(), other.dnsViewId()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessTokenResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ClientToken", (Object)this.clientToken()).add("CreatedAt", (Object)this.createdAt()).add("DnsViewId", (Object)this.dnsViewId()).add("ExpiresAt", (Object)this.expiresAt()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Value", (Object)(this.value() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "dnsViewId": {
                return Optional.ofNullable(clazz.cast(this.dnsViewId()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessTokenResponse, T> g) {
        return obj -> g.apply((CreateAccessTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String clientToken;
        private Instant createdAt;
        private String dnsViewId;
        private Instant expiresAt;
        private String name;
        private String status;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessTokenResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.clientToken(model.clientToken);
            this.createdAt(model.createdAt);
            this.dnsViewId(model.dnsViewId);
            this.expiresAt(model.expiresAt);
            this.name(model.name);
            this.status(model.status);
            this.value(model.value);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDnsViewId() {
            return this.dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TokenStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public CreateAccessTokenResponse build() {
            return new CreateAccessTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessTokenResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder clientToken(String var1);

        public Builder createdAt(Instant var1);

        public Builder dnsViewId(String var1);

        public Builder expiresAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(TokenStatus var1);

        public Builder value(String var1);
    }
}

