/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DnsAdvancedProtection {
    DGA("DGA"),
    DNS_TUNNELING("DNS_TUNNELING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DnsAdvancedProtection> VALUE_MAP;
    private final String value;

    private DnsAdvancedProtection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsAdvancedProtection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsAdvancedProtection> knownValues() {
        EnumSet<DnsAdvancedProtection> knownValues = EnumSet.allOf(DnsAdvancedProtection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DnsAdvancedProtection.class, DnsAdvancedProtection::toString);
    }
}

