/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53globalresolver.model.HostedZoneAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostedZoneAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostedZoneAssociationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(HostedZoneAssociationSummary.getter(HostedZoneAssociationSummary::id)).setter(HostedZoneAssociationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(HostedZoneAssociationSummary.getter(HostedZoneAssociationSummary::resourceArn)).setter(HostedZoneAssociationSummary.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostedZoneId").getter(HostedZoneAssociationSummary.getter(HostedZoneAssociationSummary::hostedZoneId)).setter(HostedZoneAssociationSummary.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostedZoneName").getter(HostedZoneAssociationSummary.getter(HostedZoneAssociationSummary::hostedZoneName)).setter(HostedZoneAssociationSummary.setter(Builder::hostedZoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(HostedZoneAssociationSummary.getter(HostedZoneAssociationSummary::name)).setter(HostedZoneAssociationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(HostedZoneAssociationSummary.getter(HostedZoneAssociationSummary::createdAt)).setter(HostedZoneAssociationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(HostedZoneAssociationSummary.getter(HostedZoneAssociationSummary::updatedAt)).setter(HostedZoneAssociationSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(HostedZoneAssociationSummary.getter(HostedZoneAssociationSummary::statusAsString)).setter(HostedZoneAssociationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_ARN_FIELD, HOSTED_ZONE_ID_FIELD, HOSTED_ZONE_NAME_FIELD, NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HostedZoneAssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String resourceArn;
    private final String hostedZoneId;
    private final String hostedZoneName;
    private final String name;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String status;

    private HostedZoneAssociationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceArn = builder.resourceArn;
        this.hostedZoneId = builder.hostedZoneId;
        this.hostedZoneName = builder.hostedZoneName;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    public final String id() {
        return this.id;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String hostedZoneName() {
        return this.hostedZoneName;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final HostedZoneAssociationStatus status() {
        return HostedZoneAssociationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneAssociationSummary)) {
            return false;
        }
        HostedZoneAssociationSummary other = (HostedZoneAssociationSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.hostedZoneName(), other.hostedZoneName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"HostedZoneAssociationSummary").add("Id", (Object)this.id()).add("ResourceArn", (Object)this.resourceArn()).add("HostedZoneId", (Object)this.hostedZoneId()).add("HostedZoneName", (Object)this.hostedZoneName()).add("Name", (Object)this.name()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "hostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "hostedZoneName": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneName()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("hostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("hostedZoneName", HOSTED_ZONE_NAME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostedZoneAssociationSummary, T> g) {
        return obj -> g.apply((HostedZoneAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String resourceArn;
        private String hostedZoneId;
        private String hostedZoneName;
        private String name;
        private Instant createdAt;
        private Instant updatedAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneAssociationSummary model) {
            this.id(model.id);
            this.resourceArn(model.resourceArn);
            this.hostedZoneId(model.hostedZoneId);
            this.hostedZoneName(model.hostedZoneName);
            this.name(model.name);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getHostedZoneName() {
            return this.hostedZoneName;
        }

        public final void setHostedZoneName(String hostedZoneName) {
            this.hostedZoneName = hostedZoneName;
        }

        @Override
        public final Builder hostedZoneName(String hostedZoneName) {
            this.hostedZoneName = hostedZoneName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HostedZoneAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public HostedZoneAssociationSummary build() {
            return new HostedZoneAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostedZoneAssociationSummary> {
        public Builder id(String var1);

        public Builder resourceArn(String var1);

        public Builder hostedZoneId(String var1);

        public Builder hostedZoneName(String var1);

        public Builder name(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(HostedZoneAssociationStatus var1);
    }
}

