/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.AccessTokenItem;
import software.amazon.awssdk.services.route53globalresolver.model.AccessTokensCopier;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessTokensResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, ListAccessTokensResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAccessTokensResponse.getter(ListAccessTokensResponse::nextToken)).setter(ListAccessTokensResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AccessTokenItem>> ACCESS_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accessTokens").getter(ListAccessTokensResponse.getter(ListAccessTokensResponse::accessTokens)).setter(ListAccessTokensResponse.setter(Builder::accessTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessTokenItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ACCESS_TOKENS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccessTokensResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AccessTokenItem> accessTokens;

    private ListAccessTokensResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessTokens = builder.accessTokens;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAccessTokens() {
        return this.accessTokens != null && !(this.accessTokens instanceof SdkAutoConstructList);
    }

    public final List<AccessTokenItem> accessTokens() {
        return this.accessTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessTokens() ? this.accessTokens() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessTokensResponse)) {
            return false;
        }
        ListAccessTokensResponse other = (ListAccessTokensResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAccessTokens() == other.hasAccessTokens() && Objects.equals(this.accessTokens(), other.accessTokens());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessTokensResponse").add("NextToken", (Object)this.nextToken()).add("AccessTokens", this.hasAccessTokens() ? this.accessTokens() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "accessTokens": {
                return Optional.ofNullable(clazz.cast(this.accessTokens()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("accessTokens", ACCESS_TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessTokensResponse, T> g) {
        return obj -> g.apply((ListAccessTokensResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AccessTokenItem> accessTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessTokensResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.accessTokens(model.accessTokens);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AccessTokenItem.Builder> getAccessTokens() {
            List<AccessTokenItem.Builder> result = AccessTokensCopier.copyToBuilder(this.accessTokens);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessTokens(Collection<AccessTokenItem.BuilderImpl> accessTokens) {
            this.accessTokens = AccessTokensCopier.copyFromBuilder(accessTokens);
        }

        @Override
        public final Builder accessTokens(Collection<AccessTokenItem> accessTokens) {
            this.accessTokens = AccessTokensCopier.copy(accessTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTokens(AccessTokenItem ... accessTokens) {
            this.accessTokens(Arrays.asList(accessTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTokens(Consumer<AccessTokenItem.Builder> ... accessTokens) {
            this.accessTokens(Stream.of(accessTokens).map(c -> (AccessTokenItem)((AccessTokenItem.Builder)AccessTokenItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessTokensResponse build() {
            return new ListAccessTokensResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessTokensResponse> {
        public Builder nextToken(String var1);

        public Builder accessTokens(Collection<AccessTokenItem> var1);

        public Builder accessTokens(AccessTokenItem ... var1);

        public Builder accessTokens(Consumer<AccessTokenItem.Builder> ... var1);
    }
}

