/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.ManagedFirewallDomainListsCopier;
import software.amazon.awssdk.services.route53globalresolver.model.ManagedFirewallDomainListsItem;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListManagedFirewallDomainListsResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, ListManagedFirewallDomainListsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListManagedFirewallDomainListsResponse.getter(ListManagedFirewallDomainListsResponse::nextToken)).setter(ListManagedFirewallDomainListsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ManagedFirewallDomainListsItem>> MANAGED_FIREWALL_DOMAIN_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedFirewallDomainLists").getter(ListManagedFirewallDomainListsResponse.getter(ListManagedFirewallDomainListsResponse::managedFirewallDomainLists)).setter(ListManagedFirewallDomainListsResponse.setter(Builder::managedFirewallDomainLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedFirewallDomainLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedFirewallDomainListsItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MANAGED_FIREWALL_DOMAIN_LISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListManagedFirewallDomainListsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ManagedFirewallDomainListsItem> managedFirewallDomainLists;

    private ListManagedFirewallDomainListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.managedFirewallDomainLists = builder.managedFirewallDomainLists;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasManagedFirewallDomainLists() {
        return this.managedFirewallDomainLists != null && !(this.managedFirewallDomainLists instanceof SdkAutoConstructList);
    }

    public final List<ManagedFirewallDomainListsItem> managedFirewallDomainLists() {
        return this.managedFirewallDomainLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedFirewallDomainLists() ? this.managedFirewallDomainLists() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedFirewallDomainListsResponse)) {
            return false;
        }
        ListManagedFirewallDomainListsResponse other = (ListManagedFirewallDomainListsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasManagedFirewallDomainLists() == other.hasManagedFirewallDomainLists() && Objects.equals(this.managedFirewallDomainLists(), other.managedFirewallDomainLists());
    }

    public final String toString() {
        return ToString.builder((String)"ListManagedFirewallDomainListsResponse").add("NextToken", (Object)this.nextToken()).add("ManagedFirewallDomainLists", this.hasManagedFirewallDomainLists() ? this.managedFirewallDomainLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "managedFirewallDomainLists": {
                return Optional.ofNullable(clazz.cast(this.managedFirewallDomainLists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("managedFirewallDomainLists", MANAGED_FIREWALL_DOMAIN_LISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedFirewallDomainListsResponse, T> g) {
        return obj -> g.apply((ListManagedFirewallDomainListsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ManagedFirewallDomainListsItem> managedFirewallDomainLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedFirewallDomainListsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.managedFirewallDomainLists(model.managedFirewallDomainLists);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ManagedFirewallDomainListsItem.Builder> getManagedFirewallDomainLists() {
            List<ManagedFirewallDomainListsItem.Builder> result = ManagedFirewallDomainListsCopier.copyToBuilder(this.managedFirewallDomainLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedFirewallDomainLists(Collection<ManagedFirewallDomainListsItem.BuilderImpl> managedFirewallDomainLists) {
            this.managedFirewallDomainLists = ManagedFirewallDomainListsCopier.copyFromBuilder(managedFirewallDomainLists);
        }

        @Override
        public final Builder managedFirewallDomainLists(Collection<ManagedFirewallDomainListsItem> managedFirewallDomainLists) {
            this.managedFirewallDomainLists = ManagedFirewallDomainListsCopier.copy(managedFirewallDomainLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFirewallDomainLists(ManagedFirewallDomainListsItem ... managedFirewallDomainLists) {
            this.managedFirewallDomainLists(Arrays.asList(managedFirewallDomainLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFirewallDomainLists(Consumer<ManagedFirewallDomainListsItem.Builder> ... managedFirewallDomainLists) {
            this.managedFirewallDomainLists(Stream.of(managedFirewallDomainLists).map(c -> (ManagedFirewallDomainListsItem)((ManagedFirewallDomainListsItem.Builder)ManagedFirewallDomainListsItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListManagedFirewallDomainListsResponse build() {
            return new ListManagedFirewallDomainListsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListManagedFirewallDomainListsResponse> {
        public Builder nextToken(String var1);

        public Builder managedFirewallDomainLists(Collection<ManagedFirewallDomainListsItem> var1);

        public Builder managedFirewallDomainLists(ManagedFirewallDomainListsItem ... var1);

        public Builder managedFirewallDomainLists(Consumer<ManagedFirewallDomainListsItem.Builder> ... var1);
    }
}

