/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.DNSViewSummary;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse;

public class ListDNSViewsIterable
implements SdkIterable<ListDnsViewsResponse> {
    private final Route53GlobalResolverClient client;
    private final ListDnsViewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDNSViewsIterable(Route53GlobalResolverClient client, ListDnsViewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDnsViewsResponseFetcher();
    }

    public Iterator<ListDnsViewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DNSViewSummary> dnsViews() {
        Function<ListDnsViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dnsViews() != null) {
                return response.dnsViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDnsViewsResponseFetcher
    implements SyncPageFetcher<ListDnsViewsResponse> {
        private ListDnsViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListDnsViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDnsViewsResponse nextPage(ListDnsViewsResponse previousPage) {
            if (previousPage == null) {
                return ListDNSViewsIterable.this.client.listDNSViews(ListDNSViewsIterable.this.firstRequest);
            }
            return ListDNSViewsIterable.this.client.listDNSViews((ListDnsViewsRequest)((Object)ListDNSViewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

