/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ManagedFirewallDomainListsItem;

public class ListManagedFirewallDomainListsIterable
implements SdkIterable<ListManagedFirewallDomainListsResponse> {
    private final Route53GlobalResolverClient client;
    private final ListManagedFirewallDomainListsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedFirewallDomainListsIterable(Route53GlobalResolverClient client, ListManagedFirewallDomainListsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedFirewallDomainListsResponseFetcher();
    }

    public Iterator<ListManagedFirewallDomainListsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedFirewallDomainListsItem> managedFirewallDomainLists() {
        Function<ListManagedFirewallDomainListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedFirewallDomainLists() != null) {
                return response.managedFirewallDomainLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedFirewallDomainListsResponseFetcher
    implements SyncPageFetcher<ListManagedFirewallDomainListsResponse> {
        private ListManagedFirewallDomainListsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedFirewallDomainListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedFirewallDomainListsResponse nextPage(ListManagedFirewallDomainListsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedFirewallDomainListsIterable.this.client.listManagedFirewallDomainLists(ListManagedFirewallDomainListsIterable.this.firstRequest);
            }
            return ListManagedFirewallDomainListsIterable.this.client.listManagedFirewallDomainLists((ListManagedFirewallDomainListsRequest)((Object)ListManagedFirewallDomainListsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

