/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LinkStatus {
    PENDING_CREATION("PENDING_CREATION"),
    PENDING_REQUEST("PENDING_REQUEST"),
    REQUESTED("REQUESTED"),
    ACCEPTED("ACCEPTED"),
    ACTIVE("ACTIVE"),
    REJECTED("REJECTED"),
    FAILED("FAILED"),
    PENDING_DELETION("PENDING_DELETION"),
    DELETED("DELETED"),
    PENDING_UPDATE("PENDING_UPDATE"),
    PENDING_ISOLATION("PENDING_ISOLATION"),
    ISOLATED("ISOLATED"),
    PENDING_RESTORATION("PENDING_RESTORATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LinkStatus> VALUE_MAP;
    private final String value;

    private LinkStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LinkStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LinkStatus> knownValues() {
        EnumSet<LinkStatus> knownValues = EnumSet.allOf(LinkStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LinkStatus.class, LinkStatus::toString);
    }
}

