/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.eventnotifications.s3.model;

import java.time.Instant;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ToString;

@SdkPublicApi
public class RestoreEventData {
    private final Instant lifecycleRestorationExpiryTime;
    private final String lifecycleRestoreStorageClass;

    public RestoreEventData(String lifecycleRestorationExpiryTime, String lifecycleRestoreStorageClass) {
        this.lifecycleRestorationExpiryTime = lifecycleRestorationExpiryTime != null ? Instant.parse(lifecycleRestorationExpiryTime) : null;
        this.lifecycleRestoreStorageClass = lifecycleRestoreStorageClass;
    }

    public Instant getLifecycleRestorationExpiryTime() {
        return this.lifecycleRestorationExpiryTime;
    }

    public String getLifecycleRestoreStorageClass() {
        return this.lifecycleRestoreStorageClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreEventData that = (RestoreEventData)o;
        if (!Objects.equals(this.lifecycleRestorationExpiryTime, that.lifecycleRestorationExpiryTime)) {
            return false;
        }
        return Objects.equals(this.lifecycleRestoreStorageClass, that.lifecycleRestoreStorageClass);
    }

    public int hashCode() {
        int result = this.lifecycleRestorationExpiryTime != null ? this.lifecycleRestorationExpiryTime.hashCode() : 0;
        result = 31 * result + (this.lifecycleRestoreStorageClass != null ? this.lifecycleRestoreStorageClass.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"RestoreEventData").add("lifecycleRestorationExpiryTime", (Object)this.lifecycleRestorationExpiryTime).add("lifecycleRestoreStorageClass", (Object)this.lifecycleRestoreStorageClass).build();
    }
}

