/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3tables.model.EncryptionConfiguration;
import software.amazon.awssdk.services.s3tables.model.OpenTableFormat;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.services.s3tables.model.StorageClassConfiguration;
import software.amazon.awssdk.services.s3tables.model.TableMetadata;
import software.amazon.awssdk.services.s3tables.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTableRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, CreateTableRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(CreateTableRequest.getter(CreateTableRequest::tableBucketARN)).setter(CreateTableRequest.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(CreateTableRequest.getter(CreateTableRequest::namespace)).setter(CreateTableRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("namespace").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTableRequest.getter(CreateTableRequest::name)).setter(CreateTableRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(CreateTableRequest.getter(CreateTableRequest::formatAsString)).setter(CreateTableRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<TableMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(CreateTableRequest.getter(CreateTableRequest::metadata)).setter(CreateTableRequest.setter(Builder::metadata)).constructor(TableMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(CreateTableRequest.getter(CreateTableRequest::encryptionConfiguration)).setter(CreateTableRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<StorageClassConfiguration> STORAGE_CLASS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageClassConfiguration").getter(CreateTableRequest.getter(CreateTableRequest::storageClassConfiguration)).setter(CreateTableRequest.setter(Builder::storageClassConfiguration)).constructor(StorageClassConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageClassConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateTableRequest.getter(CreateTableRequest::tags)).setter(CreateTableRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, NAMESPACE_FIELD, NAME_FIELD, FORMAT_FIELD, METADATA_FIELD, ENCRYPTION_CONFIGURATION_FIELD, STORAGE_CLASS_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTableRequest.memberNameToFieldInitializer();
    private final String tableBucketARN;
    private final String namespace;
    private final String name;
    private final String format;
    private final TableMetadata metadata;
    private final EncryptionConfiguration encryptionConfiguration;
    private final StorageClassConfiguration storageClassConfiguration;
    private final Map<String, String> tags;

    private CreateTableRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.format = builder.format;
        this.metadata = builder.metadata;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.storageClassConfiguration = builder.storageClassConfiguration;
        this.tags = builder.tags;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String name() {
        return this.name;
    }

    public final OpenTableFormat format() {
        return OpenTableFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final TableMetadata metadata() {
        return this.metadata;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final StorageClassConfiguration storageClassConfiguration() {
        return this.storageClassConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.storageClassConfiguration(), other.storageClassConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTableRequest").add("TableBucketARN", (Object)this.tableBucketARN()).add("Namespace", (Object)this.namespace()).add("Name", (Object)this.name()).add("Format", (Object)this.formatAsString()).add("Metadata", (Object)this.metadata()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("StorageClassConfiguration", (Object)this.storageClassConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "storageClassConfiguration": {
                return Optional.ofNullable(clazz.cast(this.storageClassConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("storageClassConfiguration", STORAGE_CLASS_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTableRequest, T> g) {
        return obj -> g.apply((CreateTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private String namespace;
        private String name;
        private String format;
        private TableMetadata metadata;
        private EncryptionConfiguration encryptionConfiguration;
        private StorageClassConfiguration storageClassConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTableRequest model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.namespace(model.namespace);
            this.name(model.name);
            this.format(model.format);
            this.metadata(model.metadata);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.storageClassConfiguration(model.storageClassConfiguration);
            this.tags(model.tags);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(OpenTableFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final TableMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(TableMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(TableMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final StorageClassConfiguration.Builder getStorageClassConfiguration() {
            return this.storageClassConfiguration != null ? this.storageClassConfiguration.toBuilder() : null;
        }

        public final void setStorageClassConfiguration(StorageClassConfiguration.BuilderImpl storageClassConfiguration) {
            this.storageClassConfiguration = storageClassConfiguration != null ? storageClassConfiguration.build() : null;
        }

        @Override
        public final Builder storageClassConfiguration(StorageClassConfiguration storageClassConfiguration) {
            this.storageClassConfiguration = storageClassConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTableRequest build() {
            return new CreateTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTableRequest> {
        public Builder tableBucketARN(String var1);

        public Builder namespace(String var1);

        public Builder name(String var1);

        public Builder format(String var1);

        public Builder format(OpenTableFormat var1);

        public Builder metadata(TableMetadata var1);

        default public Builder metadata(Consumer<TableMetadata.Builder> metadata) {
            return this.metadata((TableMetadata)((TableMetadata.Builder)TableMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder storageClassConfiguration(StorageClassConfiguration var1);

        default public Builder storageClassConfiguration(Consumer<StorageClassConfiguration.Builder> storageClassConfiguration) {
            return this.storageClassConfiguration((StorageClassConfiguration)((StorageClassConfiguration.Builder)StorageClassConfiguration.builder().applyMutation(storageClassConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

