/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.s3tables.model.S3TablesResponse;
import software.amazon.awssdk.services.s3tables.model.TableMaintenanceConfigurationCopier;
import software.amazon.awssdk.services.s3tables.model.TableMaintenanceConfigurationValue;
import software.amazon.awssdk.services.s3tables.model.TableMaintenanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableMaintenanceConfigurationResponse
extends S3TablesResponse
implements ToCopyableBuilder<Builder, GetTableMaintenanceConfigurationResponse> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableARN").getter(GetTableMaintenanceConfigurationResponse.getter(GetTableMaintenanceConfigurationResponse::tableARN)).setter(GetTableMaintenanceConfigurationResponse.setter(Builder::tableARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableARN").build()}).build();
    private static final SdkField<Map<String, TableMaintenanceConfigurationValue>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(GetTableMaintenanceConfigurationResponse.getter(GetTableMaintenanceConfigurationResponse::configurationAsStrings)).setter(GetTableMaintenanceConfigurationResponse.setter(Builder::configurationWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableMaintenanceConfigurationValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTableMaintenanceConfigurationResponse.memberNameToFieldInitializer();
    private final String tableARN;
    private final Map<String, TableMaintenanceConfigurationValue> configuration;

    private GetTableMaintenanceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.tableARN = builder.tableARN;
        this.configuration = builder.configuration;
    }

    public final String tableARN() {
        return this.tableARN;
    }

    public final Map<TableMaintenanceType, TableMaintenanceConfigurationValue> configuration() {
        return TableMaintenanceConfigurationCopier.copyStringToEnum(this.configuration);
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, TableMaintenanceConfigurationValue> configurationAsStrings() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configurationAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableMaintenanceConfigurationResponse)) {
            return false;
        }
        GetTableMaintenanceConfigurationResponse other = (GetTableMaintenanceConfigurationResponse)((Object)obj);
        return Objects.equals(this.tableARN(), other.tableARN()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configurationAsStrings(), other.configurationAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableMaintenanceConfigurationResponse").add("TableARN", (Object)this.tableARN()).add("Configuration", this.hasConfiguration() ? this.configurationAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableARN": {
                return Optional.ofNullable(clazz.cast(this.tableARN()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configurationAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableARN", TABLE_ARN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableMaintenanceConfigurationResponse, T> g) {
        return obj -> g.apply((GetTableMaintenanceConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesResponse.BuilderImpl
    implements Builder {
        private String tableARN;
        private Map<String, TableMaintenanceConfigurationValue> configuration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableMaintenanceConfigurationResponse model) {
            super(model);
            this.tableARN(model.tableARN);
            this.configurationWithStrings(model.configuration);
        }

        public final String getTableARN() {
            return this.tableARN;
        }

        public final void setTableARN(String tableARN) {
            this.tableARN = tableARN;
        }

        @Override
        public final Builder tableARN(String tableARN) {
            this.tableARN = tableARN;
            return this;
        }

        public final Map<String, TableMaintenanceConfigurationValue.Builder> getConfiguration() {
            Map<String, TableMaintenanceConfigurationValue.Builder> result = TableMaintenanceConfigurationCopier.copyToBuilder(this.configuration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfiguration(Map<String, TableMaintenanceConfigurationValue.BuilderImpl> configuration) {
            this.configuration = TableMaintenanceConfigurationCopier.copyFromBuilder(configuration);
        }

        @Override
        public final Builder configurationWithStrings(Map<String, TableMaintenanceConfigurationValue> configuration) {
            this.configuration = TableMaintenanceConfigurationCopier.copy(configuration);
            return this;
        }

        @Override
        public final Builder configuration(Map<TableMaintenanceType, TableMaintenanceConfigurationValue> configuration) {
            this.configuration = TableMaintenanceConfigurationCopier.copyEnumToString(configuration);
            return this;
        }

        @Override
        public GetTableMaintenanceConfigurationResponse build() {
            return new GetTableMaintenanceConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableMaintenanceConfigurationResponse> {
        public Builder tableARN(String var1);

        public Builder configurationWithStrings(Map<String, TableMaintenanceConfigurationValue> var1);

        public Builder configuration(Map<TableMaintenanceType, TableMaintenanceConfigurationValue> var1);
    }
}

