/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3tables.model.EncryptionConfiguration;
import software.amazon.awssdk.services.s3tables.model.S3TablesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTableBucketEncryptionRequest
extends S3TablesRequest
implements ToCopyableBuilder<Builder, PutTableBucketEncryptionRequest> {
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableBucketARN").getter(PutTableBucketEncryptionRequest.getter(PutTableBucketEncryptionRequest::tableBucketARN)).setter(PutTableBucketEncryptionRequest.setter(Builder::tableBucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("tableBucketARN").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(PutTableBucketEncryptionRequest.getter(PutTableBucketEncryptionRequest::encryptionConfiguration)).setter(PutTableBucketEncryptionRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_ARN_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutTableBucketEncryptionRequest.memberNameToFieldInitializer();
    private final String tableBucketARN;
    private final EncryptionConfiguration encryptionConfiguration;

    private PutTableBucketEncryptionRequest(BuilderImpl builder) {
        super(builder);
        this.tableBucketARN = builder.tableBucketARN;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String tableBucketARN() {
        return this.tableBucketARN;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTableBucketEncryptionRequest)) {
            return false;
        }
        PutTableBucketEncryptionRequest other = (PutTableBucketEncryptionRequest)((Object)obj);
        return Objects.equals(this.tableBucketARN(), other.tableBucketARN()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutTableBucketEncryptionRequest").add("TableBucketARN", (Object)this.tableBucketARN()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tableBucketARN": {
                return Optional.ofNullable(clazz.cast(this.tableBucketARN()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tableBucketARN", TABLE_BUCKET_ARN_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutTableBucketEncryptionRequest, T> g) {
        return obj -> g.apply((PutTableBucketEncryptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3TablesRequest.BuilderImpl
    implements Builder {
        private String tableBucketARN;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutTableBucketEncryptionRequest model) {
            super(model);
            this.tableBucketARN(model.tableBucketARN);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getTableBucketARN() {
            return this.tableBucketARN;
        }

        public final void setTableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
        }

        @Override
        public final Builder tableBucketARN(String tableBucketARN) {
            this.tableBucketARN = tableBucketARN;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutTableBucketEncryptionRequest build() {
            return new PutTableBucketEncryptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3TablesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutTableBucketEncryptionRequest> {
        public Builder tableBucketARN(String var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

