/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SSEAlgorithm {
    AES256("AES256"),
    AWS_KMS("aws:kms"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SSEAlgorithm> VALUE_MAP;
    private final String value;

    private SSEAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SSEAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SSEAlgorithm> knownValues() {
        EnumSet<SSEAlgorithm> knownValues = EnumSet.allOf(SSEAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SSEAlgorithm.class, SSEAlgorithm::toString);
    }
}

