/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3tables.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TableBucketType {
    CUSTOMER("customer"),
    AWS("aws"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TableBucketType> VALUE_MAP;
    private final String value;

    private TableBucketType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TableBucketType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TableBucketType> knownValues() {
        EnumSet<TableBucketType> knownValues = EnumSet.allOf(TableBucketType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TableBucketType.class, TableBucketType::toString);
    }
}

