/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResolverType {
    AWS("AWS"),
    SELF("Self"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResolverType> VALUE_MAP;
    private final String value;

    private ResolverType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResolverType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResolverType> knownValues() {
        EnumSet<ResolverType> knownValues = EnumSet.allOf(ResolverType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResolverType.class, ResolverType::toString);
    }
}

