/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrAsyncClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.ListCommentsItem;
import software.amazon.awssdk.services.securityir.model.ListCommentsRequest;
import software.amazon.awssdk.services.securityir.model.ListCommentsResponse;

public class ListCommentsPublisher
implements SdkPublisher<ListCommentsResponse> {
    private final SecurityIrAsyncClient client;
    private final ListCommentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCommentsPublisher(SecurityIrAsyncClient client, ListCommentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCommentsPublisher(SecurityIrAsyncClient client, ListCommentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCommentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCommentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListCommentsItem> items() {
        Function<ListCommentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCommentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCommentsResponseFetcher
    implements AsyncPageFetcher<ListCommentsResponse> {
        private ListCommentsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCommentsResponse> nextPage(ListCommentsResponse previousPage) {
            if (previousPage == null) {
                return ListCommentsPublisher.this.client.listComments(ListCommentsPublisher.this.firstRequest);
            }
            return ListCommentsPublisher.this.client.listComments((ListCommentsRequest)((Object)ListCommentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

