/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.ListMembershipItem;
import software.amazon.awssdk.services.securityir.model.ListMembershipsRequest;
import software.amazon.awssdk.services.securityir.model.ListMembershipsResponse;

public class ListMembershipsIterable
implements SdkIterable<ListMembershipsResponse> {
    private final SecurityIrClient client;
    private final ListMembershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMembershipsIterable(SecurityIrClient client, ListMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMembershipsResponseFetcher();
    }

    public Iterator<ListMembershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListMembershipItem> items() {
        Function<ListMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMembershipsResponseFetcher
    implements SyncPageFetcher<ListMembershipsResponse> {
        private ListMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMembershipsResponse nextPage(ListMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListMembershipsIterable.this.client.listMemberships(ListMembershipsIterable.this.firstRequest);
            }
            return ListMembershipsIterable.this.client.listMemberships((ListMembershipsRequest)((Object)ListMembershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

